/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl.config;

import com.mongodb.ConnectionString;
import com.mongodb.ServerAddress;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterSettings;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;

class ClusterSettingsParser {
    private final ClusterSettings settings;

    public ClusterSettingsParser(ConnectionString connectionString, JsonObject config) {
        ClusterSettings.Builder settings = ClusterSettings.builder();
        if (connectionString != null) {
            settings.applyConnectionString(connectionString);
        } else {
            List<ServerAddress> hosts = ClusterSettingsParser.parseHosts(config);
            settings.hosts(hosts);
            String replicaSet = config.getString("replicaSet");
            if (hosts.size() == 1 && replicaSet == null) {
                settings.mode(ClusterConnectionMode.SINGLE);
            } else {
                settings.mode(ClusterConnectionMode.MULTIPLE);
            }
            if (replicaSet != null) {
                settings.requiredReplicaSetName(replicaSet);
            }
        }
        this.settings = settings.build();
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    private static List<ServerAddress> parseHosts(JsonObject config) {
        ArrayList<ServerAddress> hosts = new ArrayList<ServerAddress>();
        JsonArray jsonHosts = config.getJsonArray("hosts");
        if (jsonHosts != null) {
            jsonHosts.forEach(jsonHost -> {
                ServerAddress address = ClusterSettingsParser.serverAddress((JsonObject)jsonHost);
                if (address != null) {
                    hosts.add(address);
                }
            });
        } else {
            ServerAddress address = ClusterSettingsParser.serverAddress(config);
            hosts.add(address == null ? new ServerAddress() : address);
        }
        return hosts;
    }

    private static ServerAddress serverAddress(JsonObject json) {
        if (json == null) {
            return null;
        }
        String host = json.getString("host");
        Integer port = json.getInteger("port");
        if (host == null && port == null) {
            return null;
        }
        return new ServerAddress(host, port.intValue());
    }
}

