/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.MongoService;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MongoServiceVertxEBProxy
implements MongoService {
    private Vertx _vertx;
    private String _address;
    private boolean closed;

    public MongoServiceVertxEBProxy(Vertx vertx, String address) {
        this._vertx = vertx;
        this._address = address;
    }

    @Override
    public MongoService save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("document", document);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "save");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService saveWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("document", document);
        _json.put("writeOption", writeOption.toString());
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "saveWithOptions");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("document", document);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "insert");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService insertWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("document", document);
        _json.put("writeOption", writeOption.toString());
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "insertWithOptions");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        _json.put("update", update);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "update");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService updateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        _json.put("update", update);
        _json.put("options", options.toJson());
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "updateWithOptions");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        _json.put("replace", replace);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "replace");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService replaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        _json.put("replace", replace);
        _json.put("options", options.toJson());
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "replaceWithOptions");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "find");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(this.convertList(((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
        return this;
    }

    @Override
    public MongoService findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        _json.put("options", options.toJson());
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "findWithOptions");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(this.convertList(((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
        return this;
    }

    @Override
    public MongoService findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        _json.put("fields", fields);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "findOne");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "count");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "remove");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService removeWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        _json.put("writeOption", writeOption.toString());
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "removeWithOptions");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "removeOne");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService removeOneWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        _json.put("query", query);
        _json.put("writeOption", writeOption.toString());
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "removeOneWithOptions");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService createCollection(String collectionName, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collectionName", collectionName);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "createCollection");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService getCollections(Handler<AsyncResult<List<String>>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "getCollections");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture(this.convertList(((JsonArray)((Message)res.result()).body()).getList())));
            }
        });
        return this;
    }

    @Override
    public MongoService dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("collection", collection);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "dropCollection");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public MongoService runCommand(JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) {
        if (this.closed) {
            resultHandler.handle((Object)Future.failedFuture((Throwable)new IllegalStateException("Proxy is closed")));
            return this;
        }
        JsonObject _json = new JsonObject();
        _json.put("command", command);
        DeliveryOptions _deliveryOptions = new DeliveryOptions();
        _deliveryOptions.addHeader("action", "runCommand");
        this._vertx.eventBus().send(this._address, (Object)_json, _deliveryOptions, res -> {
            if (res.failed()) {
                resultHandler.handle((Object)Future.failedFuture((Throwable)res.cause()));
            } else {
                resultHandler.handle((Object)Future.succeededFuture((Object)((Message)res.result()).body()));
            }
        });
        return this;
    }

    @Override
    public void close() {
    }

    private List<Character> convertToListChar(JsonArray arr) {
        ArrayList<Character> list = new ArrayList<Character>();
        for (Object obj : arr) {
            Integer jobj = (Integer)obj;
            list.add(Character.valueOf((char)jobj.intValue()));
        }
        return list;
    }

    private Set<Character> convertToSetChar(JsonArray arr) {
        HashSet<Character> set = new HashSet<Character>();
        for (Object obj : arr) {
            Integer jobj = (Integer)obj;
            set.add(Character.valueOf((char)jobj.intValue()));
        }
        return set;
    }

    private <T> Map<String, T> convertMap(Map map) {
        return map;
    }

    private <T> List<T> convertList(List list) {
        return list;
    }

    private <T> Set<T> convertSet(List list) {
        return new HashSet(list);
    }
}

