/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo.impl;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.MongoService;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import java.util.List;

public class MongoServiceImpl
implements MongoService {
    private final MongoClient client;

    public MongoServiceImpl(MongoClient client) {
        this.client = client;
    }

    @Override
    @Fluent
    public MongoService save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.client.save(collection, document, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService saveWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        this.client.saveWithOptions(collection, document, writeOption, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.client.insert(collection, document, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService insertWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        this.client.insertWithOptions(collection, document, writeOption, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    @Fluent
    public MongoService update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) {
        this.client.update(collection, query, update, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService updateCollection(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.client.updateCollection(collection, query, update, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    @Fluent
    public MongoService updateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.client.updateWithOptions(collection, query, update, options, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.client.updateCollectionWithOptions(collection, query, update, options, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    @Fluent
    public MongoService replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) {
        this.client.replace(collection, query, replace, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService replaceDocuments(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.client.replaceDocuments(collection, query, replace, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    @Fluent
    public MongoService replaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.client.replaceWithOptions(collection, query, replace, options, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.client.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.client.find(collection, query, resultHandler);
        return this;
    }

    @Override
    public MongoService findBatch(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.client.findBatch(collection, query, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.client.findWithOptions(collection, query, options, resultHandler);
        return this;
    }

    @Override
    public MongoService findBatchWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.client.findBatchWithOptions(collection, query, options, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.client.findOne(collection, query, fields, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService findOneAndUpdate(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.client.findOneAndUpdate(collection, query, update, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.client.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService findOneAndReplace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.client.findOneAndReplace(collection, query, replace, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.client.findOneAndReplaceWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService findOneAndDelete(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.client.findOneAndDelete(collection, query, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.client.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) {
        this.client.count(collection, query, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    @Fluent
    public MongoService remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.client.remove(collection, query, resultHandler);
        return this;
    }

    @Override
    public MongoService removeDocuments(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.client.removeDocuments(collection, query, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    @Fluent
    public MongoService removeWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        this.client.removeWithOptions(collection, query, writeOption, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.client.removeDocumentsWithOptions(collection, query, writeOption, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    @Fluent
    public MongoService removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.client.removeOne(collection, query, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService removeDocument(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.client.removeDocument(collection, query, resultHandler);
        return this;
    }

    @Override
    @Deprecated
    @Fluent
    public MongoService removeOneWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        this.client.removeOneWithOptions(collection, query, writeOption, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.client.removeDocumentWithOptions(collection, query, writeOption, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService createCollection(String collectionName, Handler<AsyncResult<Void>> resultHandler) {
        this.client.createCollection(collectionName, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService getCollections(Handler<AsyncResult<List<String>>> resultHandler) {
        this.client.getCollections(resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        this.client.dropCollection(collection, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService createIndex(String collection, JsonObject key, Handler<AsyncResult<Void>> resultHandler) {
        this.client.createIndex(collection, key, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService createIndexWithOptions(String collection, JsonObject key, IndexOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.client.createIndexWithOptions(collection, key, options, resultHandler);
        return this;
    }

    @Override
    public MongoService listIndexes(String collection, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.client.listIndexes(collection, resultHandler);
        return this;
    }

    @Override
    public MongoService dropIndex(String collection, String indexName, Handler<AsyncResult<Void>> resultHandler) {
        this.client.dropIndex(collection, indexName, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService runCommand(String commandName, JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.client.runCommand(commandName, command, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService distinct(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.client.distinct(collection, fieldName, resultClassname, resultHandler);
        return this;
    }

    @Override
    @Fluent
    public MongoService distinctBatch(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.client.distinctBatch(collection, fieldName, resultClassname, resultHandler);
        return this;
    }

    @Override
    public void close() {
        this.client.close();
    }
}

