/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mongo;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.MongoService;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.serviceproxy.ProxyHandler;
import io.vertx.serviceproxy.ServiceException;
import io.vertx.serviceproxy.ServiceExceptionMessageCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MongoServiceVertxProxyHandler
extends ProxyHandler {
    public static final long DEFAULT_CONNECTION_TIMEOUT = 300L;
    private final Vertx vertx;
    private final MongoService service;
    private final long timerID;
    private long lastAccessed;
    private final long timeoutSeconds;

    public MongoServiceVertxProxyHandler(Vertx vertx, MongoService service) {
        this(vertx, service, 300L);
    }

    public MongoServiceVertxProxyHandler(Vertx vertx, MongoService service, long timeoutInSecond) {
        this(vertx, service, true, timeoutInSecond);
    }

    public MongoServiceVertxProxyHandler(Vertx vertx, MongoService service, boolean topLevel, long timeoutSeconds) {
        this.vertx = vertx;
        this.service = service;
        this.timeoutSeconds = timeoutSeconds;
        try {
            this.vertx.eventBus().registerDefaultCodec(ServiceException.class, (MessageCodec)new ServiceExceptionMessageCodec());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (timeoutSeconds != -1L && !topLevel) {
            long period = timeoutSeconds * 1000L / 2L;
            if (period > 10000L) {
                period = 10000L;
            }
            this.timerID = vertx.setPeriodic(period, this::checkTimedOut);
        } else {
            this.timerID = -1L;
        }
        this.accessed();
    }

    public MessageConsumer<JsonObject> registerHandler(String address) {
        MessageConsumer consumer = this.vertx.eventBus().consumer(address).handler((Handler)this);
        this.setConsumer(consumer);
        return consumer;
    }

    private void checkTimedOut(long id) {
        long now = System.nanoTime();
        if (now - this.lastAccessed > this.timeoutSeconds * 1000000000L) {
            this.close();
        }
    }

    public void close() {
        if (this.timerID != -1L) {
            this.vertx.cancelTimer(this.timerID);
        }
        super.close();
    }

    private void accessed() {
        this.lastAccessed = System.nanoTime();
    }

    public void handle(Message<JsonObject> msg) {
        try {
            JsonObject json = (JsonObject)msg.body();
            String action = msg.headers().get("action");
            if (action == null) {
                throw new IllegalStateException("action not specified");
            }
            this.accessed();
            switch (action) {
                case "save": {
                    this.service.save((String)json.getValue("collection"), (JsonObject)json.getValue("document"), this.createHandler(msg));
                    break;
                }
                case "saveWithOptions": {
                    this.service.saveWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("document"), json.getString("writeOption") == null ? null : WriteOption.valueOf((String)json.getString("writeOption")), this.createHandler(msg));
                    break;
                }
                case "insert": {
                    this.service.insert((String)json.getValue("collection"), (JsonObject)json.getValue("document"), this.createHandler(msg));
                    break;
                }
                case "insertWithOptions": {
                    this.service.insertWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("document"), json.getString("writeOption") == null ? null : WriteOption.valueOf((String)json.getString("writeOption")), this.createHandler(msg));
                    break;
                }
                case "update": {
                    this.service.update((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("update"), this.createHandler(msg));
                    break;
                }
                case "updateCollection": {
                    this.service.updateCollection((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("update"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((MongoClientUpdateResult)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "updateWithOptions": {
                    this.service.updateWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("update"), json.getJsonObject("options") == null ? null : new UpdateOptions(json.getJsonObject("options")), this.createHandler(msg));
                    break;
                }
                case "updateCollectionWithOptions": {
                    this.service.updateCollectionWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("update"), json.getJsonObject("options") == null ? null : new UpdateOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((MongoClientUpdateResult)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "replace": {
                    this.service.replace((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("replace"), this.createHandler(msg));
                    break;
                }
                case "replaceDocuments": {
                    this.service.replaceDocuments((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("replace"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((MongoClientUpdateResult)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "replaceWithOptions": {
                    this.service.replaceWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("replace"), json.getJsonObject("options") == null ? null : new UpdateOptions(json.getJsonObject("options")), this.createHandler(msg));
                    break;
                }
                case "replaceDocumentsWithOptions": {
                    this.service.replaceDocumentsWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("replace"), json.getJsonObject("options") == null ? null : new UpdateOptions(json.getJsonObject("options")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((MongoClientUpdateResult)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "bulkWrite": {
                    this.service.bulkWrite((String)json.getValue("collection"), json.getJsonArray("operations").stream().map(o -> new BulkOperation((JsonObject)o)).collect(Collectors.toList()), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((MongoClientBulkWriteResult)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "bulkWriteWithOptions": {
                    this.service.bulkWriteWithOptions((String)json.getValue("collection"), json.getJsonArray("operations").stream().map(o -> new BulkOperation((JsonObject)o)).collect(Collectors.toList()), json.getJsonObject("bulkWriteOptions") == null ? null : new BulkWriteOptions(json.getJsonObject("bulkWriteOptions")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((MongoClientBulkWriteResult)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "find": {
                    this.service.find((String)json.getValue("collection"), (JsonObject)json.getValue("query"), this.createListHandler(msg));
                    break;
                }
                case "findBatch": {
                    this.service.findBatch((String)json.getValue("collection"), (JsonObject)json.getValue("query"), this.createHandler(msg));
                    break;
                }
                case "findWithOptions": {
                    this.service.findWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), json.getJsonObject("options") == null ? null : new FindOptions(json.getJsonObject("options")), this.createListHandler(msg));
                    break;
                }
                case "findBatchWithOptions": {
                    this.service.findBatchWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), json.getJsonObject("options") == null ? null : new FindOptions(json.getJsonObject("options")), this.createHandler(msg));
                    break;
                }
                case "findOne": {
                    this.service.findOne((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("fields"), this.createHandler(msg));
                    break;
                }
                case "findOneAndUpdate": {
                    this.service.findOneAndUpdate((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("update"), this.createHandler(msg));
                    break;
                }
                case "findOneAndUpdateWithOptions": {
                    this.service.findOneAndUpdateWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("update"), json.getJsonObject("findOptions") == null ? null : new FindOptions(json.getJsonObject("findOptions")), json.getJsonObject("updateOptions") == null ? null : new UpdateOptions(json.getJsonObject("updateOptions")), this.createHandler(msg));
                    break;
                }
                case "findOneAndReplace": {
                    this.service.findOneAndReplace((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("replace"), this.createHandler(msg));
                    break;
                }
                case "findOneAndReplaceWithOptions": {
                    this.service.findOneAndReplaceWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), (JsonObject)json.getValue("update"), json.getJsonObject("findOptions") == null ? null : new FindOptions(json.getJsonObject("findOptions")), json.getJsonObject("updateOptions") == null ? null : new UpdateOptions(json.getJsonObject("updateOptions")), this.createHandler(msg));
                    break;
                }
                case "findOneAndDelete": {
                    this.service.findOneAndDelete((String)json.getValue("collection"), (JsonObject)json.getValue("query"), this.createHandler(msg));
                    break;
                }
                case "findOneAndDeleteWithOptions": {
                    this.service.findOneAndDeleteWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), json.getJsonObject("findOptions") == null ? null : new FindOptions(json.getJsonObject("findOptions")), this.createHandler(msg));
                    break;
                }
                case "count": {
                    this.service.count((String)json.getValue("collection"), (JsonObject)json.getValue("query"), this.createHandler(msg));
                    break;
                }
                case "remove": {
                    this.service.remove((String)json.getValue("collection"), (JsonObject)json.getValue("query"), this.createHandler(msg));
                    break;
                }
                case "removeDocuments": {
                    this.service.removeDocuments((String)json.getValue("collection"), (JsonObject)json.getValue("query"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((MongoClientDeleteResult)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "removeWithOptions": {
                    this.service.removeWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), json.getString("writeOption") == null ? null : WriteOption.valueOf((String)json.getString("writeOption")), this.createHandler(msg));
                    break;
                }
                case "removeDocumentsWithOptions": {
                    this.service.removeDocumentsWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), json.getString("writeOption") == null ? null : WriteOption.valueOf((String)json.getString("writeOption")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((MongoClientDeleteResult)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "removeOne": {
                    this.service.removeOne((String)json.getValue("collection"), (JsonObject)json.getValue("query"), this.createHandler(msg));
                    break;
                }
                case "removeDocument": {
                    this.service.removeDocument((String)json.getValue("collection"), (JsonObject)json.getValue("query"), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((MongoClientDeleteResult)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "removeOneWithOptions": {
                    this.service.removeOneWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), json.getString("writeOption") == null ? null : WriteOption.valueOf((String)json.getString("writeOption")), this.createHandler(msg));
                    break;
                }
                case "removeDocumentWithOptions": {
                    this.service.removeDocumentWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("query"), json.getString("writeOption") == null ? null : WriteOption.valueOf((String)json.getString("writeOption")), res -> {
                        if (res.failed()) {
                            if (res.cause() instanceof ServiceException) {
                                msg.reply((Object)res.cause());
                            } else {
                                msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                            }
                        } else {
                            msg.reply(res.result() == null ? null : ((MongoClientDeleteResult)res.result()).toJson());
                        }
                    });
                    break;
                }
                case "createCollection": {
                    this.service.createCollection((String)json.getValue("collectionName"), this.createHandler(msg));
                    break;
                }
                case "getCollections": {
                    this.service.getCollections(this.createListHandler(msg));
                    break;
                }
                case "dropCollection": {
                    this.service.dropCollection((String)json.getValue("collection"), this.createHandler(msg));
                    break;
                }
                case "createIndex": {
                    this.service.createIndex((String)json.getValue("collection"), (JsonObject)json.getValue("key"), this.createHandler(msg));
                    break;
                }
                case "createIndexWithOptions": {
                    this.service.createIndexWithOptions((String)json.getValue("collection"), (JsonObject)json.getValue("key"), json.getJsonObject("options") == null ? null : new IndexOptions(json.getJsonObject("options")), this.createHandler(msg));
                    break;
                }
                case "listIndexes": {
                    this.service.listIndexes((String)json.getValue("collection"), this.createHandler(msg));
                    break;
                }
                case "dropIndex": {
                    this.service.dropIndex((String)json.getValue("collection"), (String)json.getValue("indexName"), this.createHandler(msg));
                    break;
                }
                case "runCommand": {
                    this.service.runCommand((String)json.getValue("commandName"), (JsonObject)json.getValue("command"), this.createHandler(msg));
                    break;
                }
                case "distinct": {
                    this.service.distinct((String)json.getValue("collection"), (String)json.getValue("fieldName"), (String)json.getValue("resultClassname"), this.createHandler(msg));
                    break;
                }
                case "distinctBatch": {
                    this.service.distinctBatch((String)json.getValue("collection"), (String)json.getValue("fieldName"), (String)json.getValue("resultClassname"), this.createHandler(msg));
                    break;
                }
                case "close": {
                    this.service.close();
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid action: " + action);
                }
            }
        }
        catch (Throwable t) {
            msg.reply((Object)new ServiceException(500, t.getMessage()));
            throw t;
        }
    }

    private <T> Handler<AsyncResult<T>> createHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else if (res.result() != null && res.result().getClass().isEnum()) {
                msg.reply((Object)((Enum)res.result()).name());
            } else {
                msg.reply(res.result());
            }
        };
    }

    private <T> Handler<AsyncResult<List<T>>> createListHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                msg.reply((Object)new JsonArray((List)res.result()));
            }
        };
    }

    private <T> Handler<AsyncResult<Set<T>>> createSetHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                msg.reply((Object)new JsonArray(new ArrayList((Collection)res.result())));
            }
        };
    }

    private Handler<AsyncResult<List<Character>>> createListCharHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (List)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    private Handler<AsyncResult<Set<Character>>> createSetCharHandler(Message msg) {
        return res -> {
            if (res.failed()) {
                if (res.cause() instanceof ServiceException) {
                    msg.reply((Object)res.cause());
                } else {
                    msg.reply((Object)new ServiceException(-1, res.cause().getMessage()));
                }
            } else {
                JsonArray arr = new JsonArray();
                for (Character chr : (Set)res.result()) {
                    arr.add(Integer.valueOf(chr.charValue()));
                }
                msg.reply((Object)arr);
            }
        };
    }

    private <T> Map<String, T> convertMap(Map map) {
        return map;
    }

    private <T> List<T> convertList(List list) {
        return list;
    }

    private <T> Set<T> convertSet(List list) {
        return new HashSet(list);
    }
}

