/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.reactivex.ext.mongo;

import io.reactivex.Completable;
import io.reactivex.Single;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.lang.reactivex.RxGen;
import io.vertx.lang.reactivex.TypeArg;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.impl.AsyncResultCompletable;
import io.vertx.reactivex.core.impl.AsyncResultSingle;
import io.vertx.reactivex.ext.mongo.MongoClient;
import java.util.List;

@RxGen(value=io.vertx.ext.mongo.MongoService.class)
public class MongoService
extends MongoClient {
    public static final TypeArg<MongoService> __TYPE_ARG = new TypeArg(obj -> new MongoService((io.vertx.ext.mongo.MongoService)obj), MongoService::getDelegate);
    private final io.vertx.ext.mongo.MongoService delegate;

    public MongoService(io.vertx.ext.mongo.MongoService delegate) {
        super((io.vertx.ext.mongo.MongoClient)delegate);
        this.delegate = delegate;
    }

    public io.vertx.ext.mongo.MongoService getDelegate() {
        return this.delegate;
    }

    public static MongoService createEventBusProxy(Vertx vertx, String address) {
        MongoService ret = MongoService.newInstance(io.vertx.ext.mongo.MongoService.createEventBusProxy(vertx.getDelegate(), address));
        return ret;
    }

    public MongoService save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.save(collection, document, (Handler)resultHandler);
        return this;
    }

    public Single<String> rxSave(String collection, JsonObject document) {
        return new AsyncResultSingle(handler -> this.save(collection, document, (Handler)handler));
    }

    public MongoService saveWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.saveWithOptions(collection, document, writeOption, (Handler)resultHandler);
        return this;
    }

    public Single<String> rxSaveWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return new AsyncResultSingle(handler -> this.saveWithOptions(collection, document, writeOption, (Handler)handler));
    }

    public MongoService insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.insert(collection, document, (Handler)resultHandler);
        return this;
    }

    public Single<String> rxInsert(String collection, JsonObject document) {
        return new AsyncResultSingle(handler -> this.insert(collection, document, (Handler)handler));
    }

    public MongoService insertWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) {
        this.delegate.insertWithOptions(collection, document, writeOption, (Handler)resultHandler);
        return this;
    }

    public Single<String> rxInsertWithOptions(String collection, JsonObject document, WriteOption writeOption) {
        return new AsyncResultSingle(handler -> this.insertWithOptions(collection, document, writeOption, (Handler)handler));
    }

    public MongoService update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.update(collection, query, update, (Handler)resultHandler);
        return this;
    }

    public Completable rxUpdate(String collection, JsonObject query, JsonObject update) {
        return new AsyncResultCompletable(handler -> this.update(collection, query, update, (Handler)handler));
    }

    public MongoService updateCollection(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollection(collection, query, update, (Handler)resultHandler);
        return this;
    }

    public Single<MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonObject update) {
        return new AsyncResultSingle(handler -> this.updateCollection(collection, query, update, (Handler)handler));
    }

    public MongoService updateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.updateWithOptions(collection, query, update, options, (Handler)resultHandler);
        return this;
    }

    public Completable rxUpdateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        return new AsyncResultCompletable(handler -> this.updateWithOptions(collection, query, update, options, (Handler)handler));
    }

    public MongoService updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.updateCollectionWithOptions(collection, query, update, options, (Handler)resultHandler);
        return this;
    }

    public Single<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) {
        return new AsyncResultSingle(handler -> this.updateCollectionWithOptions(collection, query, update, options, (Handler)handler));
    }

    public MongoService replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.replace(collection, query, replace, (Handler)resultHandler);
        return this;
    }

    public Completable rxReplace(String collection, JsonObject query, JsonObject replace) {
        return new AsyncResultCompletable(handler -> this.replace(collection, query, replace, (Handler)handler));
    }

    public MongoService replaceDocuments(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.replaceDocuments(collection, query, replace, (Handler)resultHandler);
        return this;
    }

    public Single<MongoClientUpdateResult> rxReplaceDocuments(String collection, JsonObject query, JsonObject replace) {
        return new AsyncResultSingle(handler -> this.replaceDocuments(collection, query, replace, (Handler)handler));
    }

    public MongoService replaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.replaceWithOptions(collection, query, replace, options, (Handler)resultHandler);
        return this;
    }

    public Completable rxReplaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        return new AsyncResultCompletable(handler -> this.replaceWithOptions(collection, query, replace, options, (Handler)handler));
    }

    public MongoService replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) {
        this.delegate.replaceDocumentsWithOptions(collection, query, replace, options, (Handler)resultHandler);
        return this;
    }

    public Single<MongoClientUpdateResult> rxReplaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) {
        return new AsyncResultSingle(handler -> this.replaceDocumentsWithOptions(collection, query, replace, options, (Handler)handler));
    }

    public MongoService bulkWrite(String collection, List<BulkOperation> operations, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        this.delegate.bulkWrite(collection, (List)operations, (Handler)resultHandler);
        return this;
    }

    public Single<MongoClientBulkWriteResult> rxBulkWrite(String collection, List<BulkOperation> operations) {
        return new AsyncResultSingle(handler -> this.bulkWrite(collection, (List)operations, (Handler)handler));
    }

    public MongoService bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) {
        this.delegate.bulkWriteWithOptions(collection, (List)operations, bulkWriteOptions, (Handler)resultHandler);
        return this;
    }

    public Single<MongoClientBulkWriteResult> rxBulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) {
        return new AsyncResultSingle(handler -> this.bulkWriteWithOptions(collection, (List)operations, bulkWriteOptions, (Handler)handler));
    }

    public MongoService find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.delegate.find(collection, query, (Handler)resultHandler);
        return this;
    }

    public Single<List<JsonObject>> rxFind(String collection, JsonObject query) {
        return new AsyncResultSingle(handler -> this.find(collection, query, (Handler)handler));
    }

    public MongoService findBatch(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findBatch(collection, query, (Handler)resultHandler);
        return this;
    }

    public Single<JsonObject> rxFindBatch(String collection, JsonObject query) {
        return new AsyncResultSingle(handler -> this.findBatch(collection, query, (Handler)handler));
    }

    public MongoService findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) {
        this.delegate.findWithOptions(collection, query, options, (Handler)resultHandler);
        return this;
    }

    public Single<List<JsonObject>> rxFindWithOptions(String collection, JsonObject query, FindOptions options) {
        return new AsyncResultSingle(handler -> this.findWithOptions(collection, query, options, (Handler)handler));
    }

    public MongoService findBatchWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findBatchWithOptions(collection, query, options, (Handler)resultHandler);
        return this;
    }

    public Single<JsonObject> rxFindBatchWithOptions(String collection, JsonObject query, FindOptions options) {
        return new AsyncResultSingle(handler -> this.findBatchWithOptions(collection, query, options, (Handler)handler));
    }

    public MongoService findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOne(collection, query, fields, (Handler)resultHandler);
        return this;
    }

    public Single<JsonObject> rxFindOne(String collection, JsonObject query, JsonObject fields) {
        return new AsyncResultSingle(handler -> this.findOne(collection, query, fields, (Handler)handler));
    }

    public MongoService findOneAndUpdate(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndUpdate(collection, query, update, (Handler)resultHandler);
        return this;
    }

    public Single<JsonObject> rxFindOneAndUpdate(String collection, JsonObject query, JsonObject update) {
        return new AsyncResultSingle(handler -> this.findOneAndUpdate(collection, query, update, (Handler)handler));
    }

    public MongoService findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, (Handler)resultHandler);
        return this;
    }

    public Single<JsonObject> rxFindOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        return new AsyncResultSingle(handler -> this.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, (Handler)handler));
    }

    public MongoService findOneAndReplace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndReplace(collection, query, replace, (Handler)resultHandler);
        return this;
    }

    public Single<JsonObject> rxFindOneAndReplace(String collection, JsonObject query, JsonObject replace) {
        return new AsyncResultSingle(handler -> this.findOneAndReplace(collection, query, replace, (Handler)handler));
    }

    public MongoService findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndReplaceWithOptions(collection, query, update, findOptions, updateOptions, (Handler)resultHandler);
        return this;
    }

    public Single<JsonObject> rxFindOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) {
        return new AsyncResultSingle(handler -> this.findOneAndReplaceWithOptions(collection, query, update, findOptions, updateOptions, (Handler)handler));
    }

    public MongoService findOneAndDelete(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndDelete(collection, query, (Handler)resultHandler);
        return this;
    }

    public Single<JsonObject> rxFindOneAndDelete(String collection, JsonObject query) {
        return new AsyncResultSingle(handler -> this.findOneAndDelete(collection, query, (Handler)handler));
    }

    public MongoService findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.findOneAndDeleteWithOptions(collection, query, findOptions, (Handler)resultHandler);
        return this;
    }

    public Single<JsonObject> rxFindOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) {
        return new AsyncResultSingle(handler -> this.findOneAndDeleteWithOptions(collection, query, findOptions, (Handler)handler));
    }

    public MongoService count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) {
        this.delegate.count(collection, query, (Handler)resultHandler);
        return this;
    }

    public Single<Long> rxCount(String collection, JsonObject query) {
        return new AsyncResultSingle(handler -> this.count(collection, query, (Handler)handler));
    }

    public MongoService remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.remove(collection, query, (Handler)resultHandler);
        return this;
    }

    public Completable rxRemove(String collection, JsonObject query) {
        return new AsyncResultCompletable(handler -> this.remove(collection, query, (Handler)handler));
    }

    public MongoService removeDocuments(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocuments(collection, query, (Handler)resultHandler);
        return this;
    }

    public Single<MongoClientDeleteResult> rxRemoveDocuments(String collection, JsonObject query) {
        return new AsyncResultSingle(handler -> this.removeDocuments(collection, query, (Handler)handler));
    }

    public MongoService removeWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.removeWithOptions(collection, query, writeOption, (Handler)resultHandler);
        return this;
    }

    public Completable rxRemoveWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return new AsyncResultCompletable(handler -> this.removeWithOptions(collection, query, writeOption, (Handler)handler));
    }

    public MongoService removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocumentsWithOptions(collection, query, writeOption, (Handler)resultHandler);
        return this;
    }

    public Single<MongoClientDeleteResult> rxRemoveDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return new AsyncResultSingle(handler -> this.removeDocumentsWithOptions(collection, query, writeOption, (Handler)handler));
    }

    public MongoService removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.removeOne(collection, query, (Handler)resultHandler);
        return this;
    }

    public Completable rxRemoveOne(String collection, JsonObject query) {
        return new AsyncResultCompletable(handler -> this.removeOne(collection, query, (Handler)handler));
    }

    public MongoService removeDocument(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocument(collection, query, (Handler)resultHandler);
        return this;
    }

    public Single<MongoClientDeleteResult> rxRemoveDocument(String collection, JsonObject query) {
        return new AsyncResultSingle(handler -> this.removeDocument(collection, query, (Handler)handler));
    }

    public MongoService removeOneWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.removeOneWithOptions(collection, query, writeOption, (Handler)resultHandler);
        return this;
    }

    public Completable rxRemoveOneWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return new AsyncResultCompletable(handler -> this.removeOneWithOptions(collection, query, writeOption, (Handler)handler));
    }

    public MongoService removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) {
        this.delegate.removeDocumentWithOptions(collection, query, writeOption, (Handler)resultHandler);
        return this;
    }

    public Single<MongoClientDeleteResult> rxRemoveDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) {
        return new AsyncResultSingle(handler -> this.removeDocumentWithOptions(collection, query, writeOption, (Handler)handler));
    }

    public MongoService createCollection(String collectionName, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createCollection(collectionName, (Handler)resultHandler);
        return this;
    }

    public Completable rxCreateCollection(String collectionName) {
        return new AsyncResultCompletable(handler -> this.createCollection(collectionName, (Handler)handler));
    }

    public MongoService getCollections(Handler<AsyncResult<List<String>>> resultHandler) {
        this.delegate.getCollections((Handler)resultHandler);
        return this;
    }

    public Single<List<String>> rxGetCollections() {
        return new AsyncResultSingle(handler -> this.getCollections((Handler)handler));
    }

    public MongoService dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.dropCollection(collection, (Handler)resultHandler);
        return this;
    }

    public Completable rxDropCollection(String collection) {
        return new AsyncResultCompletable(handler -> this.dropCollection(collection, (Handler)handler));
    }

    public MongoService createIndex(String collection, JsonObject key, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createIndex(collection, key, (Handler)resultHandler);
        return this;
    }

    public Completable rxCreateIndex(String collection, JsonObject key) {
        return new AsyncResultCompletable(handler -> this.createIndex(collection, key, (Handler)handler));
    }

    public MongoService createIndexWithOptions(String collection, JsonObject key, IndexOptions options, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.createIndexWithOptions(collection, key, options, (Handler)resultHandler);
        return this;
    }

    public Completable rxCreateIndexWithOptions(String collection, JsonObject key, IndexOptions options) {
        return new AsyncResultCompletable(handler -> this.createIndexWithOptions(collection, key, options, (Handler)handler));
    }

    public MongoService listIndexes(String collection, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.listIndexes(collection, (Handler)resultHandler);
        return this;
    }

    public Single<JsonArray> rxListIndexes(String collection) {
        return new AsyncResultSingle(handler -> this.listIndexes(collection, (Handler)handler));
    }

    public MongoService dropIndex(String collection, String indexName, Handler<AsyncResult<Void>> resultHandler) {
        this.delegate.dropIndex(collection, indexName, (Handler)resultHandler);
        return this;
    }

    public Completable rxDropIndex(String collection, String indexName) {
        return new AsyncResultCompletable(handler -> this.dropIndex(collection, indexName, (Handler)handler));
    }

    public MongoService runCommand(String commandName, JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.runCommand(commandName, command, (Handler)resultHandler);
        return this;
    }

    public Single<JsonObject> rxRunCommand(String commandName, JsonObject command) {
        return new AsyncResultSingle(handler -> this.runCommand(commandName, command, (Handler)handler));
    }

    public MongoService distinct(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.delegate.distinct(collection, fieldName, resultClassname, (Handler)resultHandler);
        return this;
    }

    public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname) {
        return new AsyncResultSingle(handler -> this.distinct(collection, fieldName, resultClassname, (Handler)handler));
    }

    public MongoService distinctBatch(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.delegate.distinctBatch(collection, fieldName, resultClassname, (Handler)resultHandler);
        return this;
    }

    public Single<JsonObject> rxDistinctBatch(String collection, String fieldName, String resultClassname) {
        return new AsyncResultSingle(handler -> this.distinctBatch(collection, fieldName, resultClassname, (Handler)handler));
    }

    public void close() {
        this.delegate.close();
    }

    public static MongoService newInstance(io.vertx.ext.mongo.MongoService arg) {
        return arg != null ? new MongoService(arg) : null;
    }
}

