/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

/** @module vertx-mongo-js/mongo_client */
var utils = require('vertx-js/util/utils');
var Vertx = require('vertx-js/vertx');
var ReadStream = require('vertx-js/read_stream');

var io = Packages.io;
var JsonObject = io.vertx.core.json.JsonObject;
var JMongoClient = Java.type('io.vertx.ext.mongo.MongoClient');
var MongoClientDeleteResult = Java.type('io.vertx.ext.mongo.MongoClientDeleteResult');
var IndexOptions = Java.type('io.vertx.ext.mongo.IndexOptions');
var BulkOperation = Java.type('io.vertx.ext.mongo.BulkOperation');
var BulkWriteOptions = Java.type('io.vertx.ext.mongo.BulkWriteOptions');
var FindOptions = Java.type('io.vertx.ext.mongo.FindOptions');
var MongoClientBulkWriteResult = Java.type('io.vertx.ext.mongo.MongoClientBulkWriteResult');
var MongoClientUpdateResult = Java.type('io.vertx.ext.mongo.MongoClientUpdateResult');
var UpdateOptions = Java.type('io.vertx.ext.mongo.UpdateOptions');

/**
 @class
*/
var MongoClient = function(j_val) {

  var j_mongoClient = j_val;
  var that = this;

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.save = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoClient["save(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), function(ar) {
      if (ar.succeeded()) {
        arg2(ar.result(), null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.saveWithOptions = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'string' || __args[2] == null) && typeof __args[3] === 'function') {
      j_mongoClient["saveWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), arg2 == null ? null : io.vertx.ext.mongo.WriteOption.valueOf(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(ar.result(), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.insert = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoClient["insert(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), function(ar) {
      if (ar.succeeded()) {
        arg2(ar.result(), null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.insertWithOptions = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'string' || __args[2] == null) && typeof __args[3] === 'function') {
      j_mongoClient["insertWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), arg2 == null ? null : io.vertx.ext.mongo.WriteOption.valueOf(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(ar.result(), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.update = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoClient["update(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(null, null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.updateCollection = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoClient["updateCollection(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(utils.convReturnDataObject(ar.result()), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {Object} 
   @param arg4 {function} 
   @return {MongoClient}
   */
  this.updateWithOptions = function(arg0, arg1, arg2, arg3, arg4) {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && typeof __args[4] === 'function') {
      j_mongoClient["updateWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), arg3 != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(arg3))) : null, function(ar) {
      if (ar.succeeded()) {
        arg4(null, null);
      } else {
        arg4(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {Object} 
   @param arg4 {function} 
   @return {MongoClient}
   */
  this.updateCollectionWithOptions = function(arg0, arg1, arg2, arg3, arg4) {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && typeof __args[4] === 'function') {
      j_mongoClient["updateCollectionWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), arg3 != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(arg3))) : null, function(ar) {
      if (ar.succeeded()) {
        arg4(utils.convReturnDataObject(ar.result()), null);
      } else {
        arg4(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.replace = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoClient["replace(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(null, null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.replaceDocuments = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoClient["replaceDocuments(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(utils.convReturnDataObject(ar.result()), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {Object} 
   @param arg4 {function} 
   @return {MongoClient}
   */
  this.replaceWithOptions = function(arg0, arg1, arg2, arg3, arg4) {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && typeof __args[4] === 'function') {
      j_mongoClient["replaceWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), arg3 != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(arg3))) : null, function(ar) {
      if (ar.succeeded()) {
        arg4(null, null);
      } else {
        arg4(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {Object} 
   @param arg4 {function} 
   @return {MongoClient}
   */
  this.replaceDocumentsWithOptions = function(arg0, arg1, arg2, arg3, arg4) {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && typeof __args[4] === 'function') {
      j_mongoClient["replaceDocumentsWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), arg3 != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(arg3))) : null, function(ar) {
      if (ar.succeeded()) {
        arg4(utils.convReturnDataObject(ar.result()), null);
      } else {
        arg4(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Array.<Object>} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.bulkWrite = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && typeof __args[2] === 'function') {
      j_mongoClient["bulkWrite(java.lang.String,java.util.List,io.vertx.core.Handler)"](arg0, utils.convParamListDataObject(arg1, function(json) { return new BulkOperation(json); }), function(ar) {
      if (ar.succeeded()) {
        arg2(utils.convReturnDataObject(ar.result()), null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Array.<Object>} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.bulkWriteWithOptions = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'object' && __args[1] instanceof Array && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoClient["bulkWriteWithOptions(java.lang.String,java.util.List,io.vertx.ext.mongo.BulkWriteOptions,io.vertx.core.Handler)"](arg0, utils.convParamListDataObject(arg1, function(json) { return new BulkOperation(json); }), arg2 != null ? new BulkWriteOptions(new JsonObject(Java.asJSONCompatible(arg2))) : null, function(ar) {
      if (ar.succeeded()) {
        arg3(utils.convReturnDataObject(ar.result()), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.find = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoClient["find(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), function(ar) {
      if (ar.succeeded()) {
        arg2(utils.convReturnListSetJson(ar.result()), null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @return {ReadStream}
   */
  this.findBatch = function(arg0, arg1) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null)) {
      return utils.convReturnVertxGen(ReadStream, j_mongoClient["findBatch(java.lang.String,io.vertx.core.json.JsonObject)"](arg0, utils.convParamJsonObject(arg1)), undefined);
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.findWithOptions = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoClient["findWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.FindOptions,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), arg2 != null ? new FindOptions(new JsonObject(Java.asJSONCompatible(arg2))) : null, function(ar) {
      if (ar.succeeded()) {
        arg3(utils.convReturnListSetJson(ar.result()), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @return {ReadStream}
   */
  this.findBatchWithOptions = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null)) {
      return utils.convReturnVertxGen(ReadStream, j_mongoClient["findBatchWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.FindOptions)"](arg0, utils.convParamJsonObject(arg1), arg2 != null ? new FindOptions(new JsonObject(Java.asJSONCompatible(arg2))) : null), undefined);
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.findOne = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'object' && typeof __args[3] === 'function') {
      j_mongoClient["findOne(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(utils.convReturnJson(ar.result()), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.findOneAndUpdate = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoClient["findOneAndUpdate(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(utils.convReturnJson(ar.result()), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {Object} 
   @param arg4 {Object} 
   @param arg5 {function} 
   @return {MongoClient}
   */
  this.findOneAndUpdateWithOptions = function(arg0, arg1, arg2, arg3, arg4, arg5) {
    var __args = arguments;
    if (__args.length === 6 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && (typeof __args[4] === 'object' && __args[4] != null) && typeof __args[5] === 'function') {
      j_mongoClient["findOneAndUpdateWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.FindOptions,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), arg3 != null ? new FindOptions(new JsonObject(Java.asJSONCompatible(arg3))) : null, arg4 != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(arg4))) : null, function(ar) {
      if (ar.succeeded()) {
        arg5(utils.convReturnJson(ar.result()), null);
      } else {
        arg5(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.findOneAndReplace = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoClient["findOneAndReplace(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(utils.convReturnJson(ar.result()), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {Object} 
   @param arg4 {Object} 
   @param arg5 {function} 
   @return {MongoClient}
   */
  this.findOneAndReplaceWithOptions = function(arg0, arg1, arg2, arg3, arg4, arg5) {
    var __args = arguments;
    if (__args.length === 6 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && (typeof __args[3] === 'object' && __args[3] != null) && (typeof __args[4] === 'object' && __args[4] != null) && typeof __args[5] === 'function') {
      j_mongoClient["findOneAndReplaceWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.FindOptions,io.vertx.ext.mongo.UpdateOptions,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), utils.convParamJsonObject(arg2), arg3 != null ? new FindOptions(new JsonObject(Java.asJSONCompatible(arg3))) : null, arg4 != null ? new UpdateOptions(new JsonObject(Java.asJSONCompatible(arg4))) : null, function(ar) {
      if (ar.succeeded()) {
        arg5(utils.convReturnJson(ar.result()), null);
      } else {
        arg5(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.findOneAndDelete = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoClient["findOneAndDelete(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), function(ar) {
      if (ar.succeeded()) {
        arg2(utils.convReturnJson(ar.result()), null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.findOneAndDeleteWithOptions = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoClient["findOneAndDeleteWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.FindOptions,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), arg2 != null ? new FindOptions(new JsonObject(Java.asJSONCompatible(arg2))) : null, function(ar) {
      if (ar.succeeded()) {
        arg3(utils.convReturnJson(ar.result()), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.count = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoClient["count(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), function(ar) {
      if (ar.succeeded()) {
        arg2(utils.convReturnLong(ar.result()), null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.remove = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoClient["remove(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), function(ar) {
      if (ar.succeeded()) {
        arg2(null, null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.removeDocuments = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoClient["removeDocuments(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), function(ar) {
      if (ar.succeeded()) {
        arg2(utils.convReturnDataObject(ar.result()), null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.removeWithOptions = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_mongoClient["removeWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), io.vertx.ext.mongo.WriteOption.valueOf(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(null, null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.removeDocumentsWithOptions = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'string' || __args[2] == null) && typeof __args[3] === 'function') {
      j_mongoClient["removeDocumentsWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), arg2 == null ? null : io.vertx.ext.mongo.WriteOption.valueOf(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(utils.convReturnDataObject(ar.result()), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.removeOne = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoClient["removeOne(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), function(ar) {
      if (ar.succeeded()) {
        arg2(null, null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.removeDocument = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoClient["removeDocument(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), function(ar) {
      if (ar.succeeded()) {
        arg2(utils.convReturnDataObject(ar.result()), null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.removeOneWithOptions = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_mongoClient["removeOneWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), io.vertx.ext.mongo.WriteOption.valueOf(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(null, null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.removeDocumentWithOptions = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'string' || __args[2] == null) && typeof __args[3] === 'function') {
      j_mongoClient["removeDocumentWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.WriteOption,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), arg2 == null ? null : io.vertx.ext.mongo.WriteOption.valueOf(arg2), function(ar) {
      if (ar.succeeded()) {
        arg3(utils.convReturnDataObject(ar.result()), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {function} 
   @return {MongoClient}
   */
  this.createCollection = function(arg0, arg1) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_mongoClient["createCollection(java.lang.String,io.vertx.core.Handler)"](arg0, function(ar) {
      if (ar.succeeded()) {
        arg1(null, null);
      } else {
        arg1(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {function} 
   @return {MongoClient}
   */
  this.getCollections = function(arg0) {
    var __args = arguments;
    if (__args.length === 1 && typeof __args[0] === 'function') {
      j_mongoClient["getCollections(io.vertx.core.Handler)"](function(ar) {
      if (ar.succeeded()) {
        arg0(ar.result(), null);
      } else {
        arg0(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {function} 
   @return {MongoClient}
   */
  this.dropCollection = function(arg0, arg1) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_mongoClient["dropCollection(java.lang.String,io.vertx.core.Handler)"](arg0, function(ar) {
      if (ar.succeeded()) {
        arg1(null, null);
      } else {
        arg1(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.createIndex = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoClient["createIndex(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), function(ar) {
      if (ar.succeeded()) {
        arg2(null, null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {Object} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.createIndexWithOptions = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && (typeof __args[2] === 'object' && __args[2] != null) && typeof __args[3] === 'function') {
      j_mongoClient["createIndexWithOptions(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.ext.mongo.IndexOptions,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), arg2 != null ? new IndexOptions(new JsonObject(Java.asJSONCompatible(arg2))) : null, function(ar) {
      if (ar.succeeded()) {
        arg3(null, null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {function} 
   @return {MongoClient}
   */
  this.listIndexes = function(arg0, arg1) {
    var __args = arguments;
    if (__args.length === 2 && typeof __args[0] === 'string' && typeof __args[1] === 'function') {
      j_mongoClient["listIndexes(java.lang.String,io.vertx.core.Handler)"](arg0, function(ar) {
      if (ar.succeeded()) {
        arg1(utils.convReturnJson(ar.result()), null);
      } else {
        arg1(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.dropIndex = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'function') {
      j_mongoClient["dropIndex(java.lang.String,java.lang.String,io.vertx.core.Handler)"](arg0, arg1, function(ar) {
      if (ar.succeeded()) {
        arg2(null, null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {Object} 
   @param arg2 {function} 
   @return {MongoClient}
   */
  this.runCommand = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'function') {
      j_mongoClient["runCommand(java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, utils.convParamJsonObject(arg1), function(ar) {
      if (ar.succeeded()) {
        arg2(utils.convReturnJson(ar.result()), null);
      } else {
        arg2(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param arg3 {function} 
   @return {MongoClient}
   */
  this.distinct = function(arg0, arg1, arg2, arg3) {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && typeof __args[3] === 'function') {
      j_mongoClient["distinct(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.Handler)"](arg0, arg1, arg2, function(ar) {
      if (ar.succeeded()) {
        arg3(utils.convReturnJson(ar.result()), null);
      } else {
        arg3(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param arg3 {Object} 
   @param arg4 {function} 
   @return {MongoClient}
   */
  this.distinctWithQuery = function(arg0, arg1, arg2, arg3, arg4) {
    var __args = arguments;
    if (__args.length === 5 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && (typeof __args[3] === 'object' && __args[3] != null) && typeof __args[4] === 'function') {
      j_mongoClient["distinctWithQuery(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.json.JsonObject,io.vertx.core.Handler)"](arg0, arg1, arg2, utils.convParamJsonObject(arg3), function(ar) {
      if (ar.succeeded()) {
        arg4(utils.convReturnJson(ar.result()), null);
      } else {
        arg4(null, ar.cause());
      }
    });
      return that;
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @return {ReadStream}
   */
  this.distinctBatch = function(arg0, arg1, arg2) {
    var __args = arguments;
    if (__args.length === 3 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string') {
      return utils.convReturnVertxGen(ReadStream, j_mongoClient["distinctBatch(java.lang.String,java.lang.String,java.lang.String)"](arg0, arg1, arg2), undefined);
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public
   @param arg0 {string} 
   @param arg1 {string} 
   @param arg2 {string} 
   @param arg3 {Object} 
   @param arg4 {number} 
   @return {ReadStream}
   */
  this.distinctBatchWithQuery = function() {
    var __args = arguments;
    if (__args.length === 4 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && (typeof __args[3] === 'object' && __args[3] != null)) {
      return utils.convReturnVertxGen(ReadStream, j_mongoClient["distinctBatchWithQuery(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.json.JsonObject)"](__args[0], __args[1], __args[2], utils.convParamJsonObject(__args[3])), undefined);
    }  else if (__args.length === 5 && typeof __args[0] === 'string' && typeof __args[1] === 'string' && typeof __args[2] === 'string' && (typeof __args[3] === 'object' && __args[3] != null) && typeof __args[4] ==='number') {
      return utils.convReturnVertxGen(ReadStream, j_mongoClient["distinctBatchWithQuery(java.lang.String,java.lang.String,java.lang.String,io.vertx.core.json.JsonObject,int)"](__args[0], __args[1], __args[2], utils.convParamJsonObject(__args[3]), __args[4]), undefined);
    } else throw new TypeError('function invoked with invalid arguments');
  };

  /**

   @public

   */
  this.close = function() {
    var __args = arguments;
    if (__args.length === 0) {
      j_mongoClient["close()"]();
    } else throw new TypeError('function invoked with invalid arguments');
  };

  // A reference to the underlying Java delegate
  // NOTE! This is an internal API and must not be used in user code.
  // If you rely on this property your code is likely to break if we change it / remove it without warning.
  this._jdel = j_mongoClient;
};

MongoClient._jclass = utils.getJavaClass("io.vertx.ext.mongo.MongoClient");
MongoClient._jtype = {
  accept: function(obj) {
    return MongoClient._jclass.isInstance(obj._jdel);
  },
  wrap: function(jdel) {
    var obj = Object.create(MongoClient.prototype, {});
    MongoClient.apply(obj, arguments);
    return obj;
  },
  unwrap: function(obj) {
    return obj._jdel;
  }
};
MongoClient._create = function(jdel) {
  var obj = Object.create(MongoClient.prototype, {});
  MongoClient.apply(obj, arguments);
  return obj;
}
/**

 @memberof module:vertx-mongo-js/mongo_client
 @param vertx {Vertx} 
 @param config {Object} 
 @return {MongoClient}
 */
MongoClient.createNonShared = function(vertx, config) {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(MongoClient, JMongoClient["createNonShared(io.vertx.core.Vertx,io.vertx.core.json.JsonObject)"](vertx._jdel, utils.convParamJsonObject(config)));
  } else throw new TypeError('function invoked with invalid arguments');
};

/**

 @memberof module:vertx-mongo-js/mongo_client
 @param vertx {Vertx} 
 @param config {Object} 
 @param dataSourceName {string} 
 @return {MongoClient}
 */
MongoClient.createShared = function() {
  var __args = arguments;
  if (__args.length === 2 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null)) {
    return utils.convReturnVertxGen(MongoClient, JMongoClient["createShared(io.vertx.core.Vertx,io.vertx.core.json.JsonObject)"](__args[0]._jdel, utils.convParamJsonObject(__args[1])));
  }else if (__args.length === 3 && typeof __args[0] === 'object' && __args[0]._jdel && (typeof __args[1] === 'object' && __args[1] != null) && typeof __args[2] === 'string') {
    return utils.convReturnVertxGen(MongoClient, JMongoClient["createShared(io.vertx.core.Vertx,io.vertx.core.json.JsonObject,java.lang.String)"](__args[0]._jdel, utils.convParamJsonObject(__args[1]), __args[2]));
  } else throw new TypeError('function invoked with invalid arguments');
};

module.exports = MongoClient;