/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.mongo;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.ext.mongo.WriteOption;
import io.vertx.ext.mongo.BulkOperation;
import io.vertx.reactivex.core.Vertx;
import io.vertx.ext.mongo.MongoClientBulkWriteResult;
import io.vertx.core.json.JsonArray;
import java.util.List;
import io.vertx.ext.mongo.IndexOptions;
import io.vertx.ext.mongo.BulkWriteOptions;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.ext.mongo.MongoClientUpdateResult;
import io.vertx.ext.mongo.UpdateOptions;

/**
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.mongo.MongoService original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.mongo.MongoService.class)
public class MongoService extends MongoClient {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MongoService that = (MongoService) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<MongoService> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new MongoService((io.vertx.ext.mongo.MongoService) obj),
    MongoService::getDelegate
  );

  private final io.vertx.ext.mongo.MongoService delegate;
  
  public MongoService(io.vertx.ext.mongo.MongoService delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.mongo.MongoService getDelegate() {
    return delegate;
  }

  /**
   * Create a proxy to a service that is deployed somewhere on the event bus
   * @param vertx the Vert.x instance
   * @param address the address the service is listening on on the event bus
   * @return the service
   */
  public static MongoService createEventBusProxy(Vertx vertx, String address) { 
    MongoService ret = MongoService.newInstance(io.vertx.ext.mongo.MongoService.createEventBusProxy(vertx.getDelegate(), address));
    return ret;
  }

  public MongoService save(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) { 
    delegate.save(collection, document, resultHandler);
    return this;
  }

  public Single<String> rxSave(String collection, JsonObject document) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      save(collection, document, handler);
    });
  }

  public MongoService saveWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) { 
    delegate.saveWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  public Single<String> rxSaveWithOptions(String collection, JsonObject document, WriteOption writeOption) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      saveWithOptions(collection, document, writeOption, handler);
    });
  }

  public MongoService insert(String collection, JsonObject document, Handler<AsyncResult<String>> resultHandler) { 
    delegate.insert(collection, document, resultHandler);
    return this;
  }

  public Single<String> rxInsert(String collection, JsonObject document) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      insert(collection, document, handler);
    });
  }

  public MongoService insertWithOptions(String collection, JsonObject document, WriteOption writeOption, Handler<AsyncResult<String>> resultHandler) { 
    delegate.insertWithOptions(collection, document, writeOption, resultHandler);
    return this;
  }

  public Single<String> rxInsertWithOptions(String collection, JsonObject document, WriteOption writeOption) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<String>(handler -> {
      insertWithOptions(collection, document, writeOption, handler);
    });
  }

  public MongoService update(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.update(collection, query, update, resultHandler);
    return this;
  }

  public Completable rxUpdate(String collection, JsonObject query, JsonObject update) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      update(collection, query, update, handler);
    });
  }

  public MongoService updateCollection(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollection(collection, query, update, resultHandler);
    return this;
  }

  public Single<MongoClientUpdateResult> rxUpdateCollection(String collection, JsonObject query, JsonObject update) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<MongoClientUpdateResult>(handler -> {
      updateCollection(collection, query, update, handler);
    });
  }

  public MongoService updateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.updateWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  public Completable rxUpdateWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      updateWithOptions(collection, query, update, options, handler);
    });
  }

  public MongoService updateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.updateCollectionWithOptions(collection, query, update, options, resultHandler);
    return this;
  }

  public Single<MongoClientUpdateResult> rxUpdateCollectionWithOptions(String collection, JsonObject query, JsonObject update, UpdateOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<MongoClientUpdateResult>(handler -> {
      updateCollectionWithOptions(collection, query, update, options, handler);
    });
  }

  public MongoService replace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.replace(collection, query, replace, resultHandler);
    return this;
  }

  public Completable rxReplace(String collection, JsonObject query, JsonObject replace) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      replace(collection, query, replace, handler);
    });
  }

  public MongoService replaceDocuments(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocuments(collection, query, replace, resultHandler);
    return this;
  }

  public Single<MongoClientUpdateResult> rxReplaceDocuments(String collection, JsonObject query, JsonObject replace) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<MongoClientUpdateResult>(handler -> {
      replaceDocuments(collection, query, replace, handler);
    });
  }

  public MongoService replaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.replaceWithOptions(collection, query, replace, options, resultHandler);
    return this;
  }

  public Completable rxReplaceWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      replaceWithOptions(collection, query, replace, options, handler);
    });
  }

  public MongoService replaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options, Handler<AsyncResult<MongoClientUpdateResult>> resultHandler) { 
    delegate.replaceDocumentsWithOptions(collection, query, replace, options, resultHandler);
    return this;
  }

  public Single<MongoClientUpdateResult> rxReplaceDocumentsWithOptions(String collection, JsonObject query, JsonObject replace, UpdateOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<MongoClientUpdateResult>(handler -> {
      replaceDocumentsWithOptions(collection, query, replace, options, handler);
    });
  }

  public MongoService bulkWrite(String collection, List<BulkOperation> operations, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWrite(collection, operations, resultHandler);
    return this;
  }

  public Single<MongoClientBulkWriteResult> rxBulkWrite(String collection, List<BulkOperation> operations) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<MongoClientBulkWriteResult>(handler -> {
      bulkWrite(collection, operations, handler);
    });
  }

  public MongoService bulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions, Handler<AsyncResult<MongoClientBulkWriteResult>> resultHandler) { 
    delegate.bulkWriteWithOptions(collection, operations, bulkWriteOptions, resultHandler);
    return this;
  }

  public Single<MongoClientBulkWriteResult> rxBulkWriteWithOptions(String collection, List<BulkOperation> operations, BulkWriteOptions bulkWriteOptions) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<MongoClientBulkWriteResult>(handler -> {
      bulkWriteWithOptions(collection, operations, bulkWriteOptions, handler);
    });
  }

  public MongoService find(String collection, JsonObject query, Handler<AsyncResult<List<JsonObject>>> resultHandler) { 
    delegate.find(collection, query, resultHandler);
    return this;
  }

  public Single<List<JsonObject>> rxFind(String collection, JsonObject query) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<List<JsonObject>>(handler -> {
      find(collection, query, handler);
    });
  }

  public MongoService findWithOptions(String collection, JsonObject query, FindOptions options, Handler<AsyncResult<List<JsonObject>>> resultHandler) { 
    delegate.findWithOptions(collection, query, options, resultHandler);
    return this;
  }

  public Single<List<JsonObject>> rxFindWithOptions(String collection, JsonObject query, FindOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<List<JsonObject>>(handler -> {
      findWithOptions(collection, query, options, handler);
    });
  }

  public MongoService findOne(String collection, JsonObject query, JsonObject fields, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOne(collection, query, fields, resultHandler);
    return this;
  }

  public Single<JsonObject> rxFindOne(String collection, JsonObject query, JsonObject fields) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      findOne(collection, query, fields, handler);
    });
  }

  public MongoService findOneAndUpdate(String collection, JsonObject query, JsonObject update, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndUpdate(collection, query, update, resultHandler);
    return this;
  }

  public Single<JsonObject> rxFindOneAndUpdate(String collection, JsonObject query, JsonObject update) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      findOneAndUpdate(collection, query, update, handler);
    });
  }

  public MongoService findOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
    return this;
  }

  public Single<JsonObject> rxFindOneAndUpdateWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      findOneAndUpdateWithOptions(collection, query, update, findOptions, updateOptions, handler);
    });
  }

  public MongoService findOneAndReplace(String collection, JsonObject query, JsonObject replace, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndReplace(collection, query, replace, resultHandler);
    return this;
  }

  public Single<JsonObject> rxFindOneAndReplace(String collection, JsonObject query, JsonObject replace) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      findOneAndReplace(collection, query, replace, handler);
    });
  }

  public MongoService findOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndReplaceWithOptions(collection, query, update, findOptions, updateOptions, resultHandler);
    return this;
  }

  public Single<JsonObject> rxFindOneAndReplaceWithOptions(String collection, JsonObject query, JsonObject update, FindOptions findOptions, UpdateOptions updateOptions) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      findOneAndReplaceWithOptions(collection, query, update, findOptions, updateOptions, handler);
    });
  }

  public MongoService findOneAndDelete(String collection, JsonObject query, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndDelete(collection, query, resultHandler);
    return this;
  }

  public Single<JsonObject> rxFindOneAndDelete(String collection, JsonObject query) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      findOneAndDelete(collection, query, handler);
    });
  }

  public MongoService findOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.findOneAndDeleteWithOptions(collection, query, findOptions, resultHandler);
    return this;
  }

  public Single<JsonObject> rxFindOneAndDeleteWithOptions(String collection, JsonObject query, FindOptions findOptions) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      findOneAndDeleteWithOptions(collection, query, findOptions, handler);
    });
  }

  public MongoService count(String collection, JsonObject query, Handler<AsyncResult<Long>> resultHandler) { 
    delegate.count(collection, query, resultHandler);
    return this;
  }

  public Single<Long> rxCount(String collection, JsonObject query) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<Long>(handler -> {
      count(collection, query, handler);
    });
  }

  public MongoService remove(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.remove(collection, query, resultHandler);
    return this;
  }

  public Completable rxRemove(String collection, JsonObject query) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      remove(collection, query, handler);
    });
  }

  public MongoService removeDocuments(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocuments(collection, query, resultHandler);
    return this;
  }

  public Single<MongoClientDeleteResult> rxRemoveDocuments(String collection, JsonObject query) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<MongoClientDeleteResult>(handler -> {
      removeDocuments(collection, query, handler);
    });
  }

  public MongoService removeWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  public Completable rxRemoveWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      removeWithOptions(collection, query, writeOption, handler);
    });
  }

  public MongoService removeDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentsWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  public Single<MongoClientDeleteResult> rxRemoveDocumentsWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<MongoClientDeleteResult>(handler -> {
      removeDocumentsWithOptions(collection, query, writeOption, handler);
    });
  }

  public MongoService removeOne(String collection, JsonObject query, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeOne(collection, query, resultHandler);
    return this;
  }

  public Completable rxRemoveOne(String collection, JsonObject query) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      removeOne(collection, query, handler);
    });
  }

  public MongoService removeDocument(String collection, JsonObject query, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocument(collection, query, resultHandler);
    return this;
  }

  public Single<MongoClientDeleteResult> rxRemoveDocument(String collection, JsonObject query) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<MongoClientDeleteResult>(handler -> {
      removeDocument(collection, query, handler);
    });
  }

  public MongoService removeOneWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.removeOneWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  public Completable rxRemoveOneWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      removeOneWithOptions(collection, query, writeOption, handler);
    });
  }

  public MongoService removeDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption, Handler<AsyncResult<MongoClientDeleteResult>> resultHandler) { 
    delegate.removeDocumentWithOptions(collection, query, writeOption, resultHandler);
    return this;
  }

  public Single<MongoClientDeleteResult> rxRemoveDocumentWithOptions(String collection, JsonObject query, WriteOption writeOption) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<MongoClientDeleteResult>(handler -> {
      removeDocumentWithOptions(collection, query, writeOption, handler);
    });
  }

  public MongoService createCollection(String collectionName, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createCollection(collectionName, resultHandler);
    return this;
  }

  public Completable rxCreateCollection(String collectionName) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      createCollection(collectionName, handler);
    });
  }

  public MongoService getCollections(Handler<AsyncResult<List<String>>> resultHandler) { 
    delegate.getCollections(resultHandler);
    return this;
  }

  public Single<List<String>> rxGetCollections() { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<List<String>>(handler -> {
      getCollections(handler);
    });
  }

  public MongoService dropCollection(String collection, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.dropCollection(collection, resultHandler);
    return this;
  }

  public Completable rxDropCollection(String collection) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      dropCollection(collection, handler);
    });
  }

  public MongoService createIndex(String collection, JsonObject key, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createIndex(collection, key, resultHandler);
    return this;
  }

  public Completable rxCreateIndex(String collection, JsonObject key) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      createIndex(collection, key, handler);
    });
  }

  public MongoService createIndexWithOptions(String collection, JsonObject key, IndexOptions options, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.createIndexWithOptions(collection, key, options, resultHandler);
    return this;
  }

  public Completable rxCreateIndexWithOptions(String collection, JsonObject key, IndexOptions options) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      createIndexWithOptions(collection, key, options, handler);
    });
  }

  public MongoService listIndexes(String collection, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.listIndexes(collection, resultHandler);
    return this;
  }

  public Single<JsonArray> rxListIndexes(String collection) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonArray>(handler -> {
      listIndexes(collection, handler);
    });
  }

  public MongoService dropIndex(String collection, String indexName, Handler<AsyncResult<Void>> resultHandler) { 
    delegate.dropIndex(collection, indexName, resultHandler);
    return this;
  }

  public Completable rxDropIndex(String collection, String indexName) { 
    return new io.vertx.reactivex.core.impl.AsyncResultCompletable(handler -> {
      dropIndex(collection, indexName, handler);
    });
  }

  public MongoService runCommand(String commandName, JsonObject command, Handler<AsyncResult<JsonObject>> resultHandler) { 
    delegate.runCommand(commandName, command, resultHandler);
    return this;
  }

  public Single<JsonObject> rxRunCommand(String commandName, JsonObject command) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonObject>(handler -> {
      runCommand(commandName, command, handler);
    });
  }

  public MongoService distinct(String collection, String fieldName, String resultClassname, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.distinct(collection, fieldName, resultClassname, resultHandler);
    return this;
  }

  public Single<JsonArray> rxDistinct(String collection, String fieldName, String resultClassname) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonArray>(handler -> {
      distinct(collection, fieldName, resultClassname, handler);
    });
  }

  public MongoService distinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query, Handler<AsyncResult<JsonArray>> resultHandler) { 
    delegate.distinctWithQuery(collection, fieldName, resultClassname, query, resultHandler);
    return this;
  }

  public Single<JsonArray> rxDistinctWithQuery(String collection, String fieldName, String resultClassname, JsonObject query) { 
    return new io.vertx.reactivex.core.impl.AsyncResultSingle<JsonArray>(handler -> {
      distinctWithQuery(collection, fieldName, resultClassname, query, handler);
    });
  }

  public void close() { 
    delegate.close();
  }


  public static  MongoService newInstance(io.vertx.ext.mongo.MongoService arg) {
    return arg != null ? new MongoService(arg) : null;
  }
}
