require 'vertx/vertx'
require 'vertx/read_stream'
require 'vertx/util/utils.rb'
# Generated from io.vertx.ext.mongo.MongoClient
module VertxMongo
  class MongoClient
    # @private
    # @param j_del [::VertxMongo::MongoClient] the java delegate
    def initialize(j_del)
      @j_del = j_del
    end
    # @private
    # @return [::VertxMongo::MongoClient] the underlying java delegate
    def j_del
      @j_del
    end
    @@j_api_type = Object.new
    def @@j_api_type.accept?(obj)
      obj.class == MongoClient
    end
    def @@j_api_type.wrap(obj)
      MongoClient.new(obj)
    end
    def @@j_api_type.unwrap(obj)
      obj.j_del
    end
    def self.j_api_type
      @@j_api_type
    end
    def self.j_class
      Java::IoVertxExtMongo::MongoClient.java_class
    end
    # @param [::Vertx::Vertx] vertx 
    # @param [Hash{String => Object}] config 
    # @return [::VertxMongo::MongoClient]
    def self.create_non_shared(vertx=nil,config=nil)
      if vertx.class.method_defined?(:j_del) && config.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMongo::MongoClient.java_method(:createNonShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(vertx.j_del,::Vertx::Util::Utils.to_json_object(config)),::VertxMongo::MongoClient)
      end
      raise ArgumentError, "Invalid arguments when calling create_non_shared(#{vertx},#{config})"
    end
    # @param [::Vertx::Vertx] vertx 
    # @param [Hash{String => Object}] config 
    # @param [String] dataSourceName 
    # @return [::VertxMongo::MongoClient]
    def self.create_shared(vertx=nil,config=nil,dataSourceName=nil)
      if vertx.class.method_defined?(:j_del) && config.class == Hash && !block_given? && dataSourceName == nil
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMongo::MongoClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(vertx.j_del,::Vertx::Util::Utils.to_json_object(config)),::VertxMongo::MongoClient)
      elsif vertx.class.method_defined?(:j_del) && config.class == Hash && dataSourceName.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(Java::IoVertxExtMongo::MongoClient.java_method(:createShared, [Java::IoVertxCore::Vertx.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::java.lang.String.java_class]).call(vertx.j_del,::Vertx::Util::Utils.to_json_object(config),dataSourceName),::VertxMongo::MongoClient)
      end
      raise ArgumentError, "Invalid arguments when calling create_shared(#{vertx},#{config},#{dataSourceName})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @yield 
    # @return [self]
    def save(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && block_given?
        @j_del.java_method(:save, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling save(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] arg2 
    # @yield 
    # @return [self]
    def save_with_options(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Symbol && block_given?
        @j_del.java_method(:saveWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),Java::IoVertxExtMongo::WriteOption.valueOf(arg2.to_s),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling save_with_options(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @yield 
    # @return [self]
    def insert(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && block_given?
        @j_del.java_method(:insert, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling insert(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] arg2 
    # @yield 
    # @return [self]
    def insert_with_options(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Symbol && block_given?
        @j_del.java_method(:insertWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),Java::IoVertxExtMongo::WriteOption.valueOf(arg2.to_s),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling insert_with_options(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @yield 
    # @return [self]
    def update(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && block_given?
        @j_del.java_method(:update, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling update(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @yield 
    # @return [self]
    def update_collection(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && block_given?
        @j_del.java_method(:updateCollection, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling update_collection(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @param [Hash] arg3 
    # @yield 
    # @return [self]
    def update_with_options(arg0=nil,arg1=nil,arg2=nil,arg3=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && arg3.class == Hash && block_given?
        @j_del.java_method(:updateWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(arg3)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling update_with_options(#{arg0},#{arg1},#{arg2},#{arg3})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @param [Hash] arg3 
    # @yield 
    # @return [self]
    def update_collection_with_options(arg0=nil,arg1=nil,arg2=nil,arg3=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && arg3.class == Hash && block_given?
        @j_del.java_method(:updateCollectionWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(arg3)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling update_collection_with_options(#{arg0},#{arg1},#{arg2},#{arg3})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @yield 
    # @return [self]
    def replace(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && block_given?
        @j_del.java_method(:replace, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling replace(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @yield 
    # @return [self]
    def replace_documents(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && block_given?
        @j_del.java_method(:replaceDocuments, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling replace_documents(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @param [Hash] arg3 
    # @yield 
    # @return [self]
    def replace_with_options(arg0=nil,arg1=nil,arg2=nil,arg3=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && arg3.class == Hash && block_given?
        @j_del.java_method(:replaceWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(arg3)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling replace_with_options(#{arg0},#{arg1},#{arg2},#{arg3})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @param [Hash] arg3 
    # @yield 
    # @return [self]
    def replace_documents_with_options(arg0=nil,arg1=nil,arg2=nil,arg3=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && arg3.class == Hash && block_given?
        @j_del.java_method(:replaceDocumentsWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(arg3)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling replace_documents_with_options(#{arg0},#{arg1},#{arg2},#{arg3})"
    end
    # @param [String] arg0 
    # @param [Array<Hash>] arg1 
    # @yield 
    # @return [self]
    def bulk_write(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Array && block_given?
        @j_del.java_method(:bulkWrite, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1.map { |element| Java::IoVertxExtMongo::BulkOperation.new(::Vertx::Util::Utils.to_json_object(element)) },(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling bulk_write(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Array<Hash>] arg1 
    # @param [Hash] arg2 
    # @yield 
    # @return [self]
    def bulk_write_with_options(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Array && arg2.class == Hash && block_given?
        @j_del.java_method(:bulkWriteWithOptions, [Java::java.lang.String.java_class,Java::JavaUtil::List.java_class,Java::IoVertxExtMongo::BulkWriteOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1.map { |element| Java::IoVertxExtMongo::BulkOperation.new(::Vertx::Util::Utils.to_json_object(element)) },Java::IoVertxExtMongo::BulkWriteOptions.new(::Vertx::Util::Utils.to_json_object(arg2)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling bulk_write_with_options(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @yield 
    # @return [self]
    def find(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && block_given?
        @j_del.java_method(:find, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.encode) : nil } : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling find(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @return [::Vertx::ReadStream]
    def find_batch(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:findBatch, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1)),::Vertx::ReadStreamImpl, nil)
      end
      raise ArgumentError, "Invalid arguments when calling find_batch(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash] arg2 
    # @yield 
    # @return [self]
    def find_with_options(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && block_given?
        @j_del.java_method(:findWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(arg2)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt != nil ? JSON.parse(elt.encode) : nil } : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling find_with_options(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash] arg2 
    # @return [::Vertx::ReadStream]
    def find_batch_with_options(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:findBatchWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(arg2))),::Vertx::ReadStreamImpl, nil)
      end
      raise ArgumentError, "Invalid arguments when calling find_batch_with_options(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @yield 
    # @return [self]
    def find_one(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && block_given?
        @j_del.java_method(:findOne, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling find_one(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @yield 
    # @return [self]
    def find_one_and_update(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && block_given?
        @j_del.java_method(:findOneAndUpdate, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling find_one_and_update(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @param [Hash] arg3 
    # @param [Hash] arg4 
    # @yield 
    # @return [self]
    def find_one_and_update_with_options(arg0=nil,arg1=nil,arg2=nil,arg3=nil,arg4=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && arg3.class == Hash && arg4.class == Hash && block_given?
        @j_del.java_method(:findOneAndUpdateWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(arg3)),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(arg4)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling find_one_and_update_with_options(#{arg0},#{arg1},#{arg2},#{arg3},#{arg4})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @yield 
    # @return [self]
    def find_one_and_replace(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && block_given?
        @j_del.java_method(:findOneAndReplace, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling find_one_and_replace(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash{String => Object}] arg2 
    # @param [Hash] arg3 
    # @param [Hash] arg4 
    # @yield 
    # @return [self]
    def find_one_and_replace_with_options(arg0=nil,arg1=nil,arg2=nil,arg3=nil,arg4=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && arg3.class == Hash && arg4.class == Hash && block_given?
        @j_del.java_method(:findOneAndReplaceWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxExtMongo::UpdateOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),::Vertx::Util::Utils.to_json_object(arg2),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(arg3)),Java::IoVertxExtMongo::UpdateOptions.new(::Vertx::Util::Utils.to_json_object(arg4)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling find_one_and_replace_with_options(#{arg0},#{arg1},#{arg2},#{arg3},#{arg4})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @yield 
    # @return [self]
    def find_one_and_delete(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && block_given?
        @j_del.java_method(:findOneAndDelete, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling find_one_and_delete(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash] arg2 
    # @yield 
    # @return [self]
    def find_one_and_delete_with_options(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && block_given?
        @j_del.java_method(:findOneAndDeleteWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::FindOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),Java::IoVertxExtMongo::FindOptions.new(::Vertx::Util::Utils.to_json_object(arg2)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling find_one_and_delete_with_options(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @yield 
    # @return [self]
    def count(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && block_given?
        @j_del.java_method(:count, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling count(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @yield 
    # @return [self]
    def remove(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && block_given?
        @j_del.java_method(:remove, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling remove(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @yield 
    # @return [self]
    def remove_documents(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && block_given?
        @j_del.java_method(:removeDocuments, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling remove_documents(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] arg2 
    # @yield 
    # @return [self]
    def remove_with_options(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Symbol && block_given?
        @j_del.java_method(:removeWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),Java::IoVertxExtMongo::WriteOption.valueOf(arg2.to_s),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling remove_with_options(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] arg2 
    # @yield 
    # @return [self]
    def remove_documents_with_options(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Symbol && block_given?
        @j_del.java_method(:removeDocumentsWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),Java::IoVertxExtMongo::WriteOption.valueOf(arg2.to_s),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling remove_documents_with_options(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @yield 
    # @return [self]
    def remove_one(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && block_given?
        @j_del.java_method(:removeOne, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling remove_one(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @yield 
    # @return [self]
    def remove_document(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && block_given?
        @j_del.java_method(:removeDocument, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling remove_document(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] arg2 
    # @yield 
    # @return [self]
    def remove_one_with_options(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Symbol && block_given?
        @j_del.java_method(:removeOneWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),Java::IoVertxExtMongo::WriteOption.valueOf(arg2.to_s),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling remove_one_with_options(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [:ACKNOWLEDGED,:UNACKNOWLEDGED,:FSYNCED,:JOURNALED,:REPLICA_ACKNOWLEDGED,:MAJORITY] arg2 
    # @yield 
    # @return [self]
    def remove_document_with_options(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Symbol && block_given?
        @j_del.java_method(:removeDocumentWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::WriteOption.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),Java::IoVertxExtMongo::WriteOption.valueOf(arg2.to_s),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.toJson.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling remove_document_with_options(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def create_collection(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:createCollection, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling create_collection(#{arg0})"
    end
    # @yield 
    # @return [self]
    def get_collections
      if block_given?
        @j_del.java_method(:getCollections, [Java::IoVertxCore::Handler.java_class]).call((Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result.to_a.map { |elt| elt } : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling get_collections()"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def drop_collection(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:dropCollection, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling drop_collection(#{arg0})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @yield 
    # @return [self]
    def create_index(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && block_given?
        @j_del.java_method(:createIndex, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling create_index(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @param [Hash] arg2 
    # @yield 
    # @return [self]
    def create_index_with_options(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == Hash && arg2.class == Hash && block_given?
        @j_del.java_method(:createIndexWithOptions, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxExtMongo::IndexOptions.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),Java::IoVertxExtMongo::IndexOptions.new(::Vertx::Util::Utils.to_json_object(arg2)),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling create_index_with_options(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @yield 
    # @return [self]
    def list_indexes(arg0=nil)
      if arg0.class == String && block_given?
        @j_del.java_method(:listIndexes, [Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling list_indexes(#{arg0})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @yield 
    # @return [self]
    def drop_index(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == String && block_given?
        @j_del.java_method(:dropIndex, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling drop_index(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [Hash{String => Object}] arg1 
    # @yield 
    # @return [self]
    def run_command(arg0=nil,arg1=nil)
      if arg0.class == String && arg1.class == Hash && block_given?
        @j_del.java_method(:runCommand, [Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,::Vertx::Util::Utils.to_json_object(arg1),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling run_command(#{arg0},#{arg1})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @yield 
    # @return [self]
    def distinct(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && block_given?
        @j_del.java_method(:distinct, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling distinct(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @param [Hash{String => Object}] arg3 
    # @yield 
    # @return [self]
    def distinct_with_query(arg0=nil,arg1=nil,arg2=nil,arg3=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && arg3.class == Hash && block_given?
        @j_del.java_method(:distinctWithQuery, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::IoVertxCore::Handler.java_class]).call(arg0,arg1,arg2,::Vertx::Util::Utils.to_json_object(arg3),(Proc.new { |ar| yield(ar.failed ? ar.cause : nil, ar.succeeded ? ar.result != nil ? JSON.parse(ar.result.encode) : nil : nil) }))
        return self
      end
      raise ArgumentError, "Invalid arguments when calling distinct_with_query(#{arg0},#{arg1},#{arg2},#{arg3})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @return [::Vertx::ReadStream]
    def distinct_batch(arg0=nil,arg1=nil,arg2=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:distinctBatch, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class]).call(arg0,arg1,arg2),::Vertx::ReadStreamImpl, nil)
      end
      raise ArgumentError, "Invalid arguments when calling distinct_batch(#{arg0},#{arg1},#{arg2})"
    end
    # @param [String] arg0 
    # @param [String] arg1 
    # @param [String] arg2 
    # @param [Hash{String => Object}] arg3 
    # @param [Fixnum] arg4 
    # @return [::Vertx::ReadStream]
    def distinct_batch_with_query(arg0=nil,arg1=nil,arg2=nil,arg3=nil,arg4=nil)
      if arg0.class == String && arg1.class == String && arg2.class == String && arg3.class == Hash && !block_given? && arg4 == nil
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:distinctBatchWithQuery, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class]).call(arg0,arg1,arg2,::Vertx::Util::Utils.to_json_object(arg3)),::Vertx::ReadStreamImpl, nil)
      elsif arg0.class == String && arg1.class == String && arg2.class == String && arg3.class == Hash && arg4.class == Fixnum && !block_given?
        return ::Vertx::Util::Utils.safe_create(@j_del.java_method(:distinctBatchWithQuery, [Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::java.lang.String.java_class,Java::IoVertxCoreJson::JsonObject.java_class,Java::int.java_class]).call(arg0,arg1,arg2,::Vertx::Util::Utils.to_json_object(arg3),arg4),::Vertx::ReadStreamImpl, nil)
      end
      raise ArgumentError, "Invalid arguments when calling distinct_batch_with_query(#{arg0},#{arg1},#{arg2},#{arg3},#{arg4})"
    end
    # @return [void]
    def close
      if !block_given?
        return @j_del.java_method(:close, []).call()
      end
      raise ArgumentError, "Invalid arguments when calling close()"
    end
  end
end
