/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt;

import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.codegen.annotations.CacheReturn;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.net.SocketAddress;
import io.vertx.mqtt.MqttAuth;
import io.vertx.mqtt.MqttWill;
import io.vertx.mqtt.messages.MqttPublishMessage;
import io.vertx.mqtt.messages.MqttSubscribeMessage;
import io.vertx.mqtt.messages.MqttUnsubscribeMessage;
import java.util.List;
import javax.net.ssl.SSLSession;

@VertxGen
public interface MqttEndpoint {
    public void close();

    @CacheReturn
    public SocketAddress remoteAddress();

    @CacheReturn
    public SocketAddress localAddress();

    public boolean isSsl();

    @GenIgnore
    public SSLSession sslSession();

    @CacheReturn
    public String clientIdentifier();

    @CacheReturn
    public MqttAuth auth();

    @CacheReturn
    public MqttWill will();

    @CacheReturn
    public int protocolVersion();

    @CacheReturn
    public String protocolName();

    @CacheReturn
    public boolean isCleanSession();

    @CacheReturn
    public int keepAliveTimeSeconds();

    @CacheReturn
    public int lastMessageId();

    public void subscriptionAutoAck(boolean var1);

    public boolean isSubscriptionAutoAck();

    @Fluent
    public MqttEndpoint publishAutoAck(boolean var1);

    public boolean isPublishAutoAck();

    @Fluent
    public MqttEndpoint autoKeepAlive(boolean var1);

    public boolean isAutoKeepAlive();

    public boolean isConnected();

    @Fluent
    public MqttEndpoint setClientIdentifier(String var1);

    @Fluent
    public MqttEndpoint disconnectHandler(Handler<Void> var1);

    @Fluent
    public MqttEndpoint subscribeHandler(Handler<MqttSubscribeMessage> var1);

    @Fluent
    public MqttEndpoint unsubscribeHandler(Handler<MqttUnsubscribeMessage> var1);

    @Fluent
    public MqttEndpoint publishHandler(Handler<MqttPublishMessage> var1);

    @Fluent
    public MqttEndpoint publishAcknowledgeHandler(Handler<Integer> var1);

    @Fluent
    public MqttEndpoint publishReceivedHandler(Handler<Integer> var1);

    @Fluent
    public MqttEndpoint publishReleaseHandler(Handler<Integer> var1);

    @Fluent
    public MqttEndpoint publishCompletionHandler(Handler<Integer> var1);

    @Fluent
    public MqttEndpoint pingHandler(Handler<Void> var1);

    @Fluent
    public MqttEndpoint closeHandler(Handler<Void> var1);

    @Fluent
    public MqttEndpoint exceptionHandler(Handler<Throwable> var1);

    @Fluent
    public MqttEndpoint accept();

    @Fluent
    public MqttEndpoint accept(boolean var1);

    @Fluent
    public MqttEndpoint reject(MqttConnectReturnCode var1);

    @Fluent
    public MqttEndpoint subscribeAcknowledge(int var1, List<MqttQoS> var2);

    @Fluent
    public MqttEndpoint unsubscribeAcknowledge(int var1);

    @Fluent
    public MqttEndpoint publishAcknowledge(int var1);

    @Fluent
    public MqttEndpoint publishReceived(int var1);

    @Fluent
    public MqttEndpoint publishRelease(int var1);

    @Fluent
    public MqttEndpoint publishComplete(int var1);

    @Fluent
    public MqttEndpoint publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5);

    @Fluent
    public MqttEndpoint publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5, Handler<AsyncResult<Integer>> var6);

    @Fluent
    public MqttEndpoint publish(String var1, Buffer var2, MqttQoS var3, boolean var4, boolean var5, int var6, Handler<AsyncResult<Integer>> var7);

    @Fluent
    public MqttEndpoint pong();
}

