/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;

@DataObject
public class MqttWill {
    private final boolean isWillFlag;
    private final String willTopic;
    private final Buffer willMessage;
    private final int willQos;
    private final boolean isWillRetain;

    public MqttWill(boolean isWillFlag, String willTopic, Buffer willMessage, int willQos, boolean isWillRetain) {
        this.isWillFlag = isWillFlag;
        this.willTopic = willTopic;
        this.willMessage = willMessage;
        this.willQos = willQos;
        this.isWillRetain = isWillRetain;
    }

    public MqttWill(JsonObject json) {
        this.isWillFlag = json.getBoolean("isWillFlag");
        this.willTopic = json.getString("willTopic");
        this.willMessage = json.getBuffer("willMessage");
        this.willQos = json.getInteger("willQos");
        this.isWillRetain = json.getBoolean("isWillRetain");
    }

    public boolean isWillFlag() {
        return this.isWillFlag;
    }

    public String getWillTopic() {
        return this.willTopic;
    }

    public Buffer getWillMessage() {
        return this.willMessage;
    }

    public byte[] getWillMessageBytes() {
        return this.willMessage != null ? this.willMessage.getBytes() : null;
    }

    public int getWillQos() {
        return this.willQos;
    }

    public boolean isWillRetain() {
        return this.isWillRetain;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.put("isWillFlag", (Object)this.isWillFlag);
        json.put("willTopic", (Object)this.willTopic);
        json.put("willMessage", (Object)this.willMessage);
        json.put("willQos", (Object)this.willQos);
        json.put("isWillRetain", (Object)this.isWillRetain);
        return json;
    }
}

