/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttConnAckVariableHeader;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageFactory;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishVariableHeader;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttUnsubAckPayload;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.mqtt.MqttAuth;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttTopicSubscription;
import io.vertx.mqtt.MqttWill;
import io.vertx.mqtt.messages.MqttPublishMessage;
import io.vertx.mqtt.messages.MqttSubscribeMessage;
import io.vertx.mqtt.messages.MqttUnsubscribeMessage;
import java.util.List;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSession;

public class MqttEndpointImpl
implements MqttEndpoint {
    private static final int MAX_MESSAGE_ID = 65535;
    private static final Logger log = LoggerFactory.getLogger(MqttEndpointImpl.class);
    private final NetSocketInternal conn;
    private String clientIdentifier;
    private final MqttAuth auth;
    private final MqttWill will;
    private final boolean isCleanSession;
    private final int protocolVersion;
    private final String protocolName;
    private final int keepAliveTimeoutSeconds;
    private Handler<MqttSubscribeMessage> subscribeHandler;
    private Handler<MqttUnsubscribeMessage> unsubscribeHandler;
    private Handler<MqttPublishMessage> publishHandler;
    private Handler<Integer> pubackHandler;
    private Handler<Integer> pubrecHandler;
    private Handler<Integer> pubrelHandler;
    private Handler<Integer> pubcompHandler;
    private Handler<Void> disconnectHandler;
    private Handler<Void> pingreqHandler;
    private Handler<Void> closeHandler;
    private Handler<Throwable> exceptionHandler;
    private boolean isConnected;
    private boolean isClosed;
    private int messageIdCounter;
    private boolean isSubscriptionAutoAck;
    private boolean isPublishAutoAck;
    private boolean isAutoKeepAlive = true;

    public MqttEndpointImpl(NetSocketInternal conn, String clientIdentifier, MqttAuth auth, MqttWill will, boolean isCleanSession, int protocolVersion, String protocolName, int keepAliveTimeoutSeconds) {
        this.conn = conn;
        this.clientIdentifier = clientIdentifier;
        this.auth = auth;
        this.will = will;
        this.isCleanSession = isCleanSession;
        this.protocolVersion = protocolVersion;
        this.protocolName = protocolName;
        this.keepAliveTimeoutSeconds = keepAliveTimeoutSeconds;
    }

    @Override
    public String clientIdentifier() {
        return this.clientIdentifier;
    }

    @Override
    public MqttAuth auth() {
        return this.auth;
    }

    @Override
    public MqttWill will() {
        return this.will;
    }

    @Override
    public boolean isCleanSession() {
        return this.isCleanSession;
    }

    @Override
    public int protocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public String protocolName() {
        return this.protocolName;
    }

    @Override
    public int keepAliveTimeSeconds() {
        return this.keepAliveTimeoutSeconds;
    }

    @Override
    public int lastMessageId() {
        return this.messageIdCounter;
    }

    @Override
    public void subscriptionAutoAck(boolean isSubscriptionAutoAck) {
        this.isSubscriptionAutoAck = isSubscriptionAutoAck;
    }

    @Override
    public boolean isSubscriptionAutoAck() {
        return this.isSubscriptionAutoAck;
    }

    @Override
    public MqttEndpoint publishAutoAck(boolean isPublishAutoAck) {
        this.isPublishAutoAck = isPublishAutoAck;
        return this;
    }

    @Override
    public boolean isPublishAutoAck() {
        return this.isPublishAutoAck;
    }

    @Override
    public MqttEndpoint autoKeepAlive(boolean isAutoKeepAlive) {
        this.isAutoKeepAlive = isAutoKeepAlive;
        return this;
    }

    @Override
    public boolean isAutoKeepAlive() {
        return this.isAutoKeepAlive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected() {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            return this.isConnected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpoint setClientIdentifier(String clientIdentifier) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.clientIdentifier = clientIdentifier;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl disconnectHandler(Handler<Void> handler) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.disconnectHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl subscribeHandler(Handler<MqttSubscribeMessage> handler) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.subscribeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl unsubscribeHandler(Handler<MqttUnsubscribeMessage> handler) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.unsubscribeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl publishHandler(Handler<MqttPublishMessage> handler) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.publishHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl publishAcknowledgeHandler(Handler<Integer> handler) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.pubackHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl publishReceivedHandler(Handler<Integer> handler) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.pubrecHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl publishReleaseHandler(Handler<Integer> handler) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.pubrelHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl publishCompletionHandler(Handler<Integer> handler) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.pubcompHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl pingHandler(Handler<Void> handler) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.pingreqHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl closeHandler(Handler<Void> handler) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.closeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl exceptionHandler(Handler<Throwable> handler) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.exceptionHandler = handler;
            return this;
        }
    }

    private MqttEndpointImpl connack(MqttConnectReturnCode returnCode, boolean sessionPresent) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.CONNACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttConnAckVariableHeader variableHeader = new MqttConnAckVariableHeader(returnCode, sessionPresent);
        MqttMessage connack = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        this.write(connack);
        if (returnCode != MqttConnectReturnCode.CONNECTION_ACCEPTED) {
            this.close();
        } else {
            this.isConnected = true;
        }
        return this;
    }

    @Override
    public MqttEndpoint accept() {
        return this.accept(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl accept(boolean sessionPresent) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (this.isConnected) {
                throw new IllegalStateException("Connection already accepted");
            }
            return this.connack(MqttConnectReturnCode.CONNECTION_ACCEPTED, sessionPresent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqttEndpointImpl reject(MqttConnectReturnCode returnCode) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (returnCode == MqttConnectReturnCode.CONNECTION_ACCEPTED) {
                throw new IllegalArgumentException("Need to use the 'accept' method for accepting connection");
            }
            return this.connack(returnCode, false);
        }
    }

    @Override
    public MqttEndpointImpl subscribeAcknowledge(int subscribeMessageId, List<MqttQoS> grantedQoSLevels) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)subscribeMessageId);
        MqttSubAckPayload payload = new MqttSubAckPayload(grantedQoSLevels.stream().mapToInt(MqttQoS::value).toArray());
        MqttMessage suback = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
        this.write(suback);
        return this;
    }

    @Override
    public MqttEndpointImpl unsubscribeAcknowledge(int unsubscribeMessageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.UNSUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)unsubscribeMessageId);
        MqttUnsubAckPayload payload = new MqttUnsubAckPayload(new short[0]);
        MqttMessage unsuback = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)payload);
        this.write(unsuback);
        return this;
    }

    @Override
    public MqttEndpointImpl publishAcknowledge(int publishMessageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessageId);
        MqttMessage puback = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        this.write(puback);
        return this;
    }

    @Override
    public MqttEndpointImpl publishReceived(int publishMessageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREC, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessageId);
        MqttMessage pubrec = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        this.write(pubrec);
        return this;
    }

    @Override
    public MqttEndpointImpl publishRelease(int publishMessageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBREL, false, MqttQoS.AT_LEAST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessageId);
        MqttMessage pubrel = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        this.write(pubrel);
        return this;
    }

    @Override
    public MqttEndpointImpl publishComplete(int publishMessageId) {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBCOMP, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessageIdVariableHeader variableHeader = MqttMessageIdVariableHeader.from((int)publishMessageId);
        MqttMessage pubcomp = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, null);
        this.write(pubcomp);
        return this;
    }

    @Override
    public Future<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain) {
        return this.publish(topic, payload, qosLevel, isDup, isRetain, this.nextMessageId());
    }

    @Override
    public MqttEndpointImpl publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, Handler<AsyncResult<Integer>> publishSentHandler) {
        return this.publish(topic, payload, qosLevel, isDup, isRetain, this.nextMessageId(), (Handler)publishSentHandler);
    }

    @Override
    public Future<Integer> publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId) {
        if (messageId > 65535 || messageId < 0) {
            throw new IllegalArgumentException("messageId must be non-negative integer not larger than 65535");
        }
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PUBLISH, isDup, qosLevel, isRetain, 0);
        MqttPublishVariableHeader variableHeader = new MqttPublishVariableHeader(topic, messageId);
        ByteBuf buf = Unpooled.copiedBuffer((byte[])payload.getBytes());
        MqttMessage publish = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, (Object)variableHeader, (Object)buf);
        return this.write(publish).map((Object)variableHeader.packetId());
    }

    @Override
    public MqttEndpointImpl publish(String topic, Buffer payload, MqttQoS qosLevel, boolean isDup, boolean isRetain, int messageId, Handler<AsyncResult<Integer>> publishSentHandler) {
        Future<Integer> fut = this.publish(topic, payload, qosLevel, isDup, isRetain, messageId);
        if (publishSentHandler != null) {
            fut.onComplete(publishSentHandler);
        }
        return this;
    }

    @Override
    public MqttEndpointImpl pong() {
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.PINGRESP, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttMessage pingresp = MqttMessageFactory.newMessage((MqttFixedHeader)fixedHeader, null, null);
        this.write(pingresp);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSubscribe(MqttSubscribeMessage msg) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (this.subscribeHandler != null) {
                this.subscribeHandler.handle((Object)msg);
            }
            if (this.isSubscriptionAutoAck) {
                this.subscribeAcknowledge(msg.messageId(), msg.topicSubscriptions().stream().map(MqttTopicSubscription::qualityOfService).collect(Collectors.toList()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnsubscribe(MqttUnsubscribeMessage msg) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (this.unsubscribeHandler != null) {
                this.unsubscribeHandler.handle((Object)msg);
            }
            if (this.isSubscriptionAutoAck) {
                this.unsubscribeAcknowledge(msg.messageId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePublish(MqttPublishMessage msg) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (this.publishHandler != null) {
                this.publishHandler.handle((Object)msg);
            }
            if (this.isPublishAutoAck) {
                switch (msg.qosLevel()) {
                    case AT_LEAST_ONCE: {
                        this.publishAcknowledge(msg.messageId());
                        break;
                    }
                    case EXACTLY_ONCE: {
                        this.publishReceived(msg.messageId());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePuback(int pubackMessageId) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (this.pubackHandler != null) {
                this.pubackHandler.handle((Object)pubackMessageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePubrec(int pubrecMessageId) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (this.pubrecHandler != null) {
                this.pubrecHandler.handle((Object)pubrecMessageId);
            }
            if (this.isPublishAutoAck) {
                this.publishRelease(pubrecMessageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePubrel(int pubrelMessageId) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (this.pubrelHandler != null) {
                this.pubrelHandler.handle((Object)pubrelMessageId);
            }
            if (this.isPublishAutoAck) {
                this.publishComplete(pubrelMessageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePubcomp(int pubcompMessageId) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (this.pubcompHandler != null) {
                this.pubcompHandler.handle((Object)pubcompMessageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePingreq() {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (this.pingreqHandler != null) {
                this.pingreqHandler.handle(null);
            }
            if (this.isAutoKeepAlive) {
                this.pong();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDisconnect() {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (this.disconnectHandler != null) {
                this.disconnectHandler.handle(null);
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClosed() {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.cleanup();
            if (this.closeHandler != null) {
                this.closeHandler.handle(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle((Object)t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            this.conn.close();
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress localAddress() {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            return this.conn.localAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SocketAddress remoteAddress() {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            return this.conn.remoteAddress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSsl() {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            return this.conn.isSsl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SSLSession sslSession() {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            this.checkClosed();
            return this.conn.sslSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future<Void> write(MqttMessage mqttMessage) {
        NetSocketInternal netSocketInternal = this.conn;
        synchronized (netSocketInternal) {
            if (mqttMessage.fixedHeader().messageType() != MqttMessageType.CONNACK) {
                this.checkConnected();
            }
            return this.conn.writeMessage((Object)mqttMessage);
        }
    }

    private void checkClosed() {
        if (this.isClosed) {
            throw new IllegalStateException("MQTT endpoint is closed");
        }
    }

    private void checkConnected() {
        if (!this.isConnected) {
            throw new IllegalStateException("Connection not accepted yet");
        }
    }

    private void cleanup() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.isConnected = false;
        }
    }

    private int nextMessageId() {
        this.messageIdCounter = this.messageIdCounter % 65535 != 0 ? this.messageIdCounter + 1 : 1;
        return this.messageIdCounter;
    }
}

