/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttPubAckMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttUnacceptableProtocolVersionException;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.vertx.core.Handler;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.net.impl.VertxHandler;
import io.vertx.mqtt.MqttAuth;
import io.vertx.mqtt.MqttEndpoint;
import io.vertx.mqtt.MqttServerOptions;
import io.vertx.mqtt.MqttWill;
import io.vertx.mqtt.impl.MqttEndpointImpl;
import io.vertx.mqtt.messages.MqttUnsubscribeMessage;
import java.util.UUID;

public class MqttServerConnection {
    private static final Logger log = LoggerFactory.getLogger(MqttServerConnection.class);
    private Handler<MqttEndpoint> endpointHandler;
    private Handler<Throwable> exceptionHandler;
    private final NetSocketInternal so;
    private MqttEndpointImpl endpoint;
    private final ChannelHandlerContext chctx;
    private final MqttServerOptions options;

    public MqttServerConnection(NetSocketInternal so, Handler<MqttEndpoint> endpointHandler, Handler<Throwable> exceptionHandler, MqttServerOptions options) {
        this.so = so;
        this.endpointHandler = endpointHandler;
        this.exceptionHandler = exceptionHandler;
        this.chctx = so.channelHandlerContext();
        this.options = options;
    }

    void handleMessage(Object msg) {
        if (msg instanceof MqttMessage) {
            MqttMessage mqttMessage = (MqttMessage)msg;
            DecoderResult result = mqttMessage.decoderResult();
            if (result.isFailure()) {
                Throwable cause = result.cause();
                if (cause instanceof MqttUnacceptableProtocolVersionException) {
                    this.endpoint = new MqttEndpointImpl(this.so, null, null, null, false, 0, null, 0);
                    this.endpoint.reject(MqttConnectReturnCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION);
                } else {
                    this.chctx.pipeline().fireExceptionCaught(result.cause());
                }
                return;
            }
            if (!result.isFinished()) {
                this.chctx.pipeline().fireExceptionCaught((Throwable)new Exception("Unfinished message"));
                return;
            }
            switch (mqttMessage.fixedHeader().messageType()) {
                case CONNECT: {
                    this.handleConnect((MqttConnectMessage)msg);
                    break;
                }
                case SUBSCRIBE: {
                    MqttSubscribeMessage subscribe = (MqttSubscribeMessage)mqttMessage;
                    io.vertx.mqtt.messages.MqttSubscribeMessage mqttSubscribeMessage = io.vertx.mqtt.messages.MqttSubscribeMessage.create(subscribe.variableHeader().messageId(), subscribe.payload().topicSubscriptions());
                    this.handleSubscribe(mqttSubscribeMessage);
                    break;
                }
                case UNSUBSCRIBE: {
                    io.netty.handler.codec.mqtt.MqttUnsubscribeMessage unsubscribe = (io.netty.handler.codec.mqtt.MqttUnsubscribeMessage)mqttMessage;
                    MqttUnsubscribeMessage mqttUnsubscribeMessage = MqttUnsubscribeMessage.create(unsubscribe.variableHeader().messageId(), unsubscribe.payload().topics());
                    this.handleUnsubscribe(mqttUnsubscribeMessage);
                    break;
                }
                case PUBLISH: {
                    MqttPublishMessage publish = (MqttPublishMessage)mqttMessage;
                    ByteBuf newBuf = VertxHandler.safeBuffer((ByteBuf)publish.payload());
                    io.vertx.mqtt.messages.MqttPublishMessage mqttPublishMessage = io.vertx.mqtt.messages.MqttPublishMessage.create(publish.variableHeader().packetId(), publish.fixedHeader().qosLevel(), publish.fixedHeader().isDup(), publish.fixedHeader().isRetain(), publish.variableHeader().topicName(), newBuf);
                    this.handlePublish(mqttPublishMessage);
                    break;
                }
                case PUBACK: {
                    MqttPubAckMessage mqttPubackMessage = (MqttPubAckMessage)mqttMessage;
                    this.handlePuback(mqttPubackMessage.variableHeader().messageId());
                    break;
                }
                case PUBREC: {
                    int pubrecMessageId = ((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId();
                    this.handlePubrec(pubrecMessageId);
                    break;
                }
                case PUBREL: {
                    int pubrelMessageId = ((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId();
                    this.handlePubrel(pubrelMessageId);
                    break;
                }
                case PUBCOMP: {
                    int pubcompMessageId = ((MqttMessageIdVariableHeader)mqttMessage.variableHeader()).messageId();
                    this.handlePubcomp(pubcompMessageId);
                    break;
                }
                case PINGREQ: {
                    this.handlePingreq();
                    break;
                }
                case DISCONNECT: {
                    this.handleDisconnect();
                    break;
                }
                default: {
                    this.chctx.fireExceptionCaught((Throwable)new Exception("Wrong MQTT message type " + mqttMessage.fixedHeader().messageType()));
                    break;
                }
            }
        } else {
            this.chctx.fireExceptionCaught((Throwable)new Exception("Wrong message type " + msg.getClass().getName()));
        }
    }

    private void handleConnect(MqttConnectMessage msg) {
        if (this.endpoint != null) {
            this.endpoint.close();
            return;
        }
        MqttWill will = new MqttWill(msg.variableHeader().isWillFlag(), msg.payload().willTopic(), msg.payload().willMessageInBytes() != null ? Buffer.buffer((byte[])msg.payload().willMessageInBytes()) : null, msg.variableHeader().willQos(), msg.variableHeader().isWillRetain());
        MqttAuth auth = msg.variableHeader().hasUserName() && msg.variableHeader().hasPassword() ? new MqttAuth(msg.payload().userName(), msg.payload().password()) : null;
        boolean isZeroBytes = msg.payload().clientIdentifier() == null || msg.payload().clientIdentifier().isEmpty();
        String clientIdentifier = null;
        if (!isZeroBytes) {
            clientIdentifier = msg.payload().clientIdentifier();
        } else if (this.options.isAutoClientId()) {
            clientIdentifier = UUID.randomUUID().toString();
        }
        this.endpoint = new MqttEndpointImpl(this.so, clientIdentifier, auth, will, msg.variableHeader().isCleanSession(), msg.variableHeader().version(), msg.variableHeader().name(), msg.variableHeader().keepAliveTimeSeconds());
        this.chctx.pipeline().remove("idle");
        this.chctx.pipeline().remove("timeoutOnConnect");
        if (msg.variableHeader().keepAliveTimeSeconds() != 0) {
            int keepAliveTimeout = (int)Math.ceil((double)msg.variableHeader().keepAliveTimeSeconds() * 1.5);
            this.chctx.pipeline().addBefore("handler", "idle", (ChannelHandler)new IdleStateHandler(keepAliveTimeout, 0, 0));
            this.chctx.pipeline().addBefore("handler", "keepAliveHandler", (ChannelHandler)new ChannelDuplexHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    IdleStateEvent e;
                    if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
                        MqttServerConnection.this.endpoint.close();
                    }
                }
            });
        }
        if (isZeroBytes && !msg.variableHeader().isCleanSession()) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle((Object)new VertxException("With zero-length client-id, clean session MUST be true"));
            }
            this.endpoint.reject(MqttConnectReturnCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED);
        } else {
            this.so.exceptionHandler(t -> this.endpoint.handleException((Throwable)t));
            this.so.closeHandler(v -> this.endpoint.handleClosed());
            this.endpointHandler.handle((Object)this.endpoint);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSubscribe(io.vertx.mqtt.messages.MqttSubscribeMessage msg) {
        NetSocketInternal netSocketInternal = this.so;
        synchronized (netSocketInternal) {
            if (this.checkConnected()) {
                this.endpoint.handleSubscribe(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleUnsubscribe(MqttUnsubscribeMessage msg) {
        NetSocketInternal netSocketInternal = this.so;
        synchronized (netSocketInternal) {
            if (this.checkConnected()) {
                this.endpoint.handleUnsubscribe(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePublish(io.vertx.mqtt.messages.MqttPublishMessage msg) {
        NetSocketInternal netSocketInternal = this.so;
        synchronized (netSocketInternal) {
            if (this.checkConnected()) {
                this.endpoint.handlePublish(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePuback(int pubackMessageId) {
        NetSocketInternal netSocketInternal = this.so;
        synchronized (netSocketInternal) {
            if (this.checkConnected()) {
                this.endpoint.handlePuback(pubackMessageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePubrec(int pubrecMessageId) {
        NetSocketInternal netSocketInternal = this.so;
        synchronized (netSocketInternal) {
            if (this.checkConnected()) {
                this.endpoint.handlePubrec(pubrecMessageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePubrel(int pubrelMessageId) {
        NetSocketInternal netSocketInternal = this.so;
        synchronized (netSocketInternal) {
            if (this.checkConnected()) {
                this.endpoint.handlePubrel(pubrelMessageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePubcomp(int pubcompMessageId) {
        NetSocketInternal netSocketInternal = this.so;
        synchronized (netSocketInternal) {
            if (this.checkConnected()) {
                this.endpoint.handlePubcomp(pubcompMessageId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handlePingreq() {
        NetSocketInternal netSocketInternal = this.so;
        synchronized (netSocketInternal) {
            if (this.checkConnected()) {
                this.endpoint.handlePingreq();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDisconnect() {
        NetSocketInternal netSocketInternal = this.so;
        synchronized (netSocketInternal) {
            if (this.checkConnected()) {
                this.endpoint.handleDisconnect();
            }
        }
    }

    private boolean checkConnected() {
        NetSocketInternal netSocketInternal = this.so;
        synchronized (netSocketInternal) {
            if (this.endpoint != null && this.endpoint.isConnected()) {
                return true;
            }
            this.so.close();
            throw new IllegalStateException("Received an MQTT packet from a not connected client (CONNECT not sent yet)");
        }
    }
}

