/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mqtt.messages.impl;

import io.netty.handler.codec.mqtt.MqttProperties;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.vertx.core.buffer.Buffer;
import io.vertx.mqtt.messages.MqttPublishMessage;

public class MqttPublishMessageImpl
implements MqttPublishMessage {
    private final int messageId;
    private final MqttQoS qosLevel;
    private final boolean isDup;
    private final boolean isRetain;
    private final String topicName;
    private final Buffer payload;
    private final MqttProperties properties;
    private boolean isAcked;
    private MqttPubAckCallback ackCallback;

    public MqttPublishMessageImpl(int messageId, MqttQoS qosLevel, boolean isDup, boolean isRetain, String topicName, Buffer payload, MqttProperties properties) {
        this.messageId = messageId;
        this.qosLevel = qosLevel;
        this.isDup = isDup;
        this.isRetain = isRetain;
        this.topicName = topicName;
        this.payload = payload;
        this.properties = properties;
    }

    @Override
    public int messageId() {
        return this.messageId;
    }

    @Override
    public MqttQoS qosLevel() {
        return this.qosLevel;
    }

    @Override
    public boolean isDup() {
        return this.isDup;
    }

    @Override
    public boolean isRetain() {
        return this.isRetain;
    }

    @Override
    public String topicName() {
        return this.topicName;
    }

    @Override
    public Buffer payload() {
        return this.payload;
    }

    public void setAckCallback(MqttPubAckCallback ackCallback) {
        this.ackCallback = ackCallback;
    }

    @Override
    public void ack() {
        if (this.qosLevel == MqttQoS.AT_LEAST_ONCE || this.qosLevel == MqttQoS.EXACTLY_ONCE) {
            if (this.ackCallback == null) {
                throw new IllegalArgumentException("Callback not present. Check that Auto Ack is disabled.");
            }
            if (this.isAcked) {
                throw new IllegalArgumentException("Ack of message " + this.messageId + " altready sent.");
            }
            this.isAcked = true;
            this.ackCallback.ack();
        }
    }

    @Override
    public MqttProperties properties() {
        return this.properties;
    }

    public static interface MqttPubAckCallback {
        public void ack();
    }
}

