/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.impl.MSSQLConnectionImpl;
import io.vertx.mssqlclient.impl.MSSQLSocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;

public class MSSQLConnectionFactory
extends ConnectionFactoryBase {
    private final int desiredPacketSize;

    public MSSQLConnectionFactory(VertxInternal vertx, MSSQLConnectOptions options) {
        super(vertx, (SqlConnectOptions)options);
        this.desiredPacketSize = options.getPacketSize();
    }

    protected void initializeConfiguration(SqlConnectOptions options) {
    }

    protected void configureNetClientOptions(NetClientOptions netClientOptions) {
    }

    protected Future<Connection> doConnectInternal(SocketAddress server, String username, String password, String database, EventLoopContext context) {
        Future fut = this.netClient.connect(server);
        return fut.map(so -> {
            MSSQLSocketConnection conn = new MSSQLSocketConnection((NetSocketInternal)so, this.desiredPacketSize, false, 0, sql -> true, 1, context);
            conn.init();
            return conn;
        }).flatMap(conn -> Future.future(promise -> conn.sendPreLoginMessage(false, (Handler<AsyncResult<Void>>)promise)).flatMap(v -> Future.future(promise -> conn.sendLoginMessage(username, password, database, this.properties, (Handler<AsyncResult<Connection>>)promise))));
    }

    public Future<SqlConnection> connect(Context context) {
        ContextInternal ctx = (ContextInternal)context;
        QueryTracer tracer = ctx.tracer() == null ? null : new QueryTracer(ctx.tracer(), this.options);
        PromiseInternal promise = ctx.promise();
        this.connect(MSSQLConnectionFactory.asEventLoopContext((ContextInternal)ctx)).map(conn -> {
            MSSQLConnectionImpl msConn = new MSSQLConnectionImpl(ctx, (ConnectionFactory)this, (Connection)conn, tracer, null);
            conn.init((Connection.Holder)msConn);
            return msConn;
        }).onComplete((Handler)promise);
        return promise.future();
    }
}

