/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.json.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MSSQLConnectionUriParser {
    private static final String SCHEME_DESIGNATOR_REGEX = "(sqlserver)://";
    private static final String USER_INFO_REGEX = "((?<userinfo>[a-zA-Z0-9\\-._~%!]+(:[a-zA-Z0-9\\-._~%!]*)?)@)?";
    private static final String NET_LOCATION_REGEX = "(?<netloc>[0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+)?";
    private static final String PORT_REGEX = "(:(?<port>\\d+))?";
    private static final String DATABASE_REGEX = "(/(?<database>[a-zA-Z0-9\\-._~%!]+))?";
    private static final String ATTRIBUTES_REGEX = "(\\?(?<attributes>.*))?";
    private static final String FULL_URI_REGEX = "^(sqlserver)://((?<userinfo>[a-zA-Z0-9\\-._~%!]+(:[a-zA-Z0-9\\-._~%!]*)?)@)?(?<netloc>[0-9.]+|\\[[a-zA-Z0-9:]+]|[a-zA-Z0-9\\-._~%]+)?(:(?<port>\\d+))?(/(?<database>[a-zA-Z0-9\\-._~%!]+))?(\\?(?<attributes>.*))?$";

    public static JsonObject parse(String connectionUri) {
        try {
            JsonObject configuration = new JsonObject();
            MSSQLConnectionUriParser.doParse(connectionUri, configuration);
            return configuration;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse invalid connection URI: " + connectionUri, e);
        }
    }

    private static void doParse(String connectionUri, JsonObject configuration) {
        Pattern pattern = Pattern.compile(FULL_URI_REGEX);
        Matcher matcher = pattern.matcher(connectionUri);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Wrong syntax of connection URI");
        }
        MSSQLConnectionUriParser.parseUserAndPassword(matcher.group("userinfo"), configuration);
        MSSQLConnectionUriParser.parseNetLocation(matcher.group("netloc"), configuration);
        MSSQLConnectionUriParser.parsePort(matcher.group("port"), configuration);
        MSSQLConnectionUriParser.parseDatabaseName(matcher.group("database"), configuration);
        MSSQLConnectionUriParser.parseAttributes(matcher.group("attributes"), configuration);
    }

    private static void parseUserAndPassword(String userInfo, JsonObject configuration) {
        if (userInfo == null || userInfo.isEmpty()) {
            return;
        }
        if (MSSQLConnectionUriParser.occurExactlyOnce(userInfo, ":")) {
            int index = userInfo.indexOf(":");
            String user = userInfo.substring(0, index);
            if (user.isEmpty()) {
                throw new IllegalArgumentException("Can not only specify the password without a concrete user");
            }
            String password = userInfo.substring(index + 1);
            configuration.put("user", (Object)MSSQLConnectionUriParser.decodeUrl(user));
            configuration.put("password", (Object)MSSQLConnectionUriParser.decodeUrl(password));
        } else if (!userInfo.contains(":")) {
            configuration.put("user", (Object)MSSQLConnectionUriParser.decodeUrl(userInfo));
        } else {
            throw new IllegalArgumentException("Can not use multiple delimiters to delimit user and password");
        }
    }

    private static void parseNetLocation(String hostInfo, JsonObject configuration) {
        if (hostInfo == null || hostInfo.isEmpty()) {
            return;
        }
        MSSQLConnectionUriParser.parseNetLocationValue(MSSQLConnectionUriParser.decodeUrl(hostInfo), configuration);
    }

    private static void parsePort(String portInfo, JsonObject configuration) {
        int port;
        if (portInfo == null || portInfo.isEmpty()) {
            return;
        }
        try {
            port = Integer.parseInt(MSSQLConnectionUriParser.decodeUrl(portInfo));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("The port must be a valid integer");
        }
        if (port > 65535 || port <= 0) {
            throw new IllegalArgumentException("The port can only range in 1-65535");
        }
        configuration.put("port", (Object)port);
    }

    private static void parseDatabaseName(String databaseInfo, JsonObject configuration) {
        if (databaseInfo == null || databaseInfo.isEmpty()) {
            return;
        }
        configuration.put("database", (Object)MSSQLConnectionUriParser.decodeUrl(databaseInfo));
    }

    private static void parseAttributes(String attributesInfo, JsonObject configuration) {
        if (attributesInfo == null || attributesInfo.isEmpty()) {
            return;
        }
        HashMap properties = new HashMap();
        block16: for (String parameterPair : attributesInfo.split("&")) {
            if (parameterPair.isEmpty()) continue;
            int indexOfDelimiter = parameterPair.indexOf("=");
            if (indexOfDelimiter < 0) {
                throw new IllegalArgumentException(String.format("Missing delimiter '=' of parameters \"%s\" in the part \"%s\"", attributesInfo, parameterPair));
            }
            String key = parameterPair.substring(0, indexOfDelimiter).toLowerCase();
            String value = MSSQLConnectionUriParser.decodeUrl(parameterPair.substring(indexOfDelimiter + 1).trim());
            switch (key) {
                case "port": {
                    MSSQLConnectionUriParser.parsePort(value, configuration);
                    continue block16;
                }
                case "host": {
                    MSSQLConnectionUriParser.parseNetLocationValue(value, configuration);
                    continue block16;
                }
                case "socket": {
                    configuration.put("host", (Object)value);
                    continue block16;
                }
                case "user": {
                    configuration.put("user", (Object)value);
                    continue block16;
                }
                case "password": {
                    configuration.put("password", (Object)value);
                    continue block16;
                }
                case "database": {
                    configuration.put("database", (Object)value);
                    continue block16;
                }
                default: {
                    configuration.put(key, (Object)value);
                }
            }
        }
        if (!properties.isEmpty()) {
            configuration.put("properties", properties);
        }
    }

    private static void parseNetLocationValue(String hostValue, JsonObject configuration) {
        if (MSSQLConnectionUriParser.isRegardedAsIpv6Address(hostValue)) {
            configuration.put("host", (Object)hostValue.substring(1, hostValue.length() - 1));
        } else {
            configuration.put("host", (Object)hostValue);
        }
    }

    private static boolean isRegardedAsIpv6Address(String hostAddress) {
        return hostAddress.startsWith("[") && hostAddress.endsWith("]");
    }

    private static String decodeUrl(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("The connection uri contains unknown characters that can not be resolved.");
        }
    }

    private static boolean occurExactlyOnce(String uri, String character) {
        return uri.contains(character) && uri.indexOf(character) == uri.lastIndexOf(character);
    }
}

