/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLPool;
import io.vertx.mssqlclient.impl.MSSQLConnectionImpl;
import io.vertx.mssqlclient.spi.MSSQLDriver;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class MSSQLPoolImpl
extends PoolBase<MSSQLPoolImpl>
implements MSSQLPool {
    public static MSSQLPoolImpl create(VertxInternal vertx, List<? extends SqlConnectOptions> servers, PoolOptions poolOptions) {
        VertxInternal vx;
        MSSQLConnectOptions baseConnectOptions = MSSQLConnectOptions.wrap(servers.get(0));
        if (vertx == null) {
            if (Vertx.currentContext() != null) {
                throw new IllegalStateException("Running in a Vertx context => use MSSQLPool#pool(Vertx, MSSQLConnectOptions, PoolOptions) instead");
            }
            vx = (VertxInternal)Vertx.vertx();
        } else {
            vx = vertx;
        }
        QueryTracer tracer = vx.tracer() == null ? null : new QueryTracer(vx.tracer(), (SqlConnectOptions)baseConnectOptions);
        VertxMetrics vertxMetrics = vx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(baseConnectOptions.getSocketAddress(), "sql", baseConnectOptions.getMetricsName()) : null;
        MSSQLPoolImpl pool = new MSSQLPoolImpl(vx, baseConnectOptions, null, tracer, metrics, poolOptions);
        pool.init();
        MSSQLDriver driver = new MSSQLDriver();
        List lst = servers.stream().map(options -> driver.createConnectionFactory((Vertx)vx, (SqlConnectOptions)options)).collect(Collectors.toList());
        ConnectionFactory factory = ConnectionFactory.roundRobinSelector(lst);
        pool.connectionProvider(arg_0 -> ((ConnectionFactory)factory).connect(arg_0));
        CloseFuture closeFuture = pool.closeFuture();
        closeFuture.add((Closeable)factory);
        if (vertx == null) {
            closeFuture.future().onComplete(ar -> vx.close());
        } else {
            ContextInternal ctx = vx.getContext();
            if (ctx != null) {
                ctx.addCloseHook((Closeable)closeFuture);
            } else {
                vx.addCloseHook((Closeable)closeFuture);
            }
        }
        return pool;
    }

    private MSSQLPoolImpl(VertxInternal vertx, MSSQLConnectOptions baseConnectOptions, Supplier<Future<SqlConnectOptions>> connectOptionsProvider, QueryTracer tracer, ClientMetrics metrics, PoolOptions poolOptions) {
        super(vertx, (SqlConnectOptions)baseConnectOptions, connectOptionsProvider, tracer, metrics, 1, poolOptions);
    }

    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append('@').append('P').append(1 + index);
        return index;
    }

    protected SqlConnectionImpl wrap(ContextInternal context, ConnectionFactory factory, Connection connection) {
        return new MSSQLConnectionImpl(context, factory, connection, this.tracer, this.metrics);
    }

    @Override
    public MSSQLPool connectHandler(Handler<SqlConnection> handler) {
        return (MSSQLPool)super.connectHandler(handler);
    }
}

