/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.codec.DataType;
import io.vertx.mssqlclient.impl.codec.MSSQLPreparedStatement;
import io.vertx.mssqlclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.sqlclient.data.NullValue;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;

abstract class ExtendedQueryCommandBaseCodec<T>
extends QueryCommandBaseCodec<T, ExtendedQueryCommand<T>> {
    ExtendedQueryCommandBaseCodec(TdsMessageCodec tdsMessageCodec, ExtendedQueryCommand<T> cmd) {
        super(tdsMessageCodec, cmd);
    }

    @Override
    void encode() {
        MSSQLPreparedStatement ps = (MSSQLPreparedStatement)((ExtendedQueryCommand)this.cmd).preparedStatement();
        if (ps.handle > 0) {
            this.sendExecRequest();
        } else {
            this.sendPrepexecRequest();
        }
    }

    @Override
    protected void handleDone(short tokenType) {
        if (tokenType == 254) {
            this.handleResultSetDone();
        }
    }

    @Override
    protected void handleResultSetDone() {
        super.handleResultSetDone();
        this.rowCount = 0;
    }

    @Override
    protected void handleReturnValue(ByteBuf payload) {
        MSSQLPreparedStatement ps = (MSSQLPreparedStatement)((ExtendedQueryCommand)this.cmd).preparedStatement();
        if (ps.handle == 0) {
            short paramNameLength = payload.getUnsignedByte(payload.readerIndex() + 2);
            payload.skipBytes(13 + 2 * paramNameLength);
            ps.handle = payload.readIntLE();
        }
    }

    private void sendPrepexecRequest() {
        ByteBuf content = this.tdsMessageCodec.alloc().ioBuffer();
        this.tdsMessageCodec.encoder().encodeHeaders(content);
        content.writeShortLE(65535);
        content.writeShortLE(13);
        content.writeShortLE(0);
        MSSQLPreparedStatement ps = (MSSQLPreparedStatement)((ExtendedQueryCommand)this.cmd).ps;
        DataType.INTN.encodeParam(content, null, true, ps.handle);
        TupleInternal params = this.prepexecRequestParams();
        String paramDefinitions = this.parseParamDefinitions(params);
        DataType.NVARCHAR.encodeParam(content, null, false, paramDefinitions);
        DataType.NVARCHAR.encodeParam(content, null, false, ((ExtendedQueryCommand)this.cmd).sql());
        this.encodeParams(content, params);
        this.tdsMessageCodec.encoder().writeTdsMessage((short)3, content);
    }

    protected abstract TupleInternal prepexecRequestParams();

    void sendExecRequest() {
        ByteBuf content = this.tdsMessageCodec.alloc().ioBuffer();
        this.tdsMessageCodec.encoder().encodeHeaders(content);
        this.writeRpcRequestBatch(content);
        this.tdsMessageCodec.encoder().writeTdsMessage((short)3, content);
    }

    protected void writeRpcRequestBatch(ByteBuf packet) {
        packet.writeShortLE(65535);
        packet.writeShortLE(12);
        packet.writeShortLE(0);
        MSSQLPreparedStatement ps = (MSSQLPreparedStatement)((ExtendedQueryCommand)this.cmd).ps;
        DataType.INTN.encodeParam(packet, null, true, ps.handle);
        this.encodeParams(packet, this.execRequestParams());
    }

    protected abstract TupleInternal execRequestParams();

    private String parseParamDefinitions(TupleInternal params) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            DataType dataType;
            Class valueClass;
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append("@P").append(i + 1).append(" ");
            Object param = params.getValueInternal(i);
            if (param == null) {
                stringBuilder.append(DataType.NULL.paramDefinition(null));
                continue;
            }
            if (param instanceof NullValue) {
                valueClass = ((NullValue)param).type();
                dataType = DataType.forValueClass(valueClass);
                stringBuilder.append(dataType.paramDefinition(null));
                continue;
            }
            valueClass = param.getClass();
            dataType = DataType.forValueClass(valueClass);
            stringBuilder.append(dataType.paramDefinition(param));
        }
        return stringBuilder.toString();
    }

    private void encodeParams(ByteBuf buffer, TupleInternal params) {
        for (int i = 0; i < params.size(); ++i) {
            String name = "@P" + (i + 1);
            Object value = params.getValue(i);
            if (value == null) {
                DataType.NULL.encodeParam(buffer, name, false, null);
                continue;
            }
            DataType dataType = DataType.forValueClass(value.getClass());
            dataType.encodeParam(buffer, name, false, value);
        }
    }
}

