/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.mssqlclient.impl.utils.Utils;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.InitCommand;
import java.nio.charset.StandardCharsets;
import java.util.Map;

class InitCommandCodec
extends MSSQLCommandCodec<Connection, InitCommand> {
    InitCommandCodec(TdsMessageCodec tdsMessageCodec, InitCommand cmd) {
        super(tdsMessageCodec, cmd);
    }

    @Override
    void encode() {
        ByteBuf content = this.tdsMessageCodec.alloc().ioBuffer();
        int startIdx = content.writerIndex();
        content.writeInt(0);
        content.writeInt(0x4000074);
        content.writeIntLE(this.tdsMessageCodec.encoder().packetSize());
        content.writeIntLE(0);
        content.writeIntLE(0);
        content.writeIntLE(0);
        content.writeByte(-64);
        content.writeByte(2);
        content.writeByte(0);
        content.writeByte(0);
        content.writeIntLE(0);
        content.writeIntLE(0);
        Map properties = ((InitCommand)this.cmd).properties();
        String hostName = Utils.getHostName();
        int hostNameOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(hostName.length());
        String userName = ((InitCommand)this.cmd).username();
        int userNameOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(userName.length());
        String password = ((InitCommand)this.cmd).password();
        int passwordOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(password.length());
        CharSequence appName = (CharSequence)properties.get("appName");
        if (appName == null || appName.length() == 0) {
            appName = "vertx-mssql-client";
        }
        int appNameOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(appName.length());
        String serverName = ((InitCommand)this.cmd).connection().socket().remoteAddress().host();
        int serverNameOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(serverName.length());
        int unusedOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(0);
        CharSequence interfaceLibraryName = (CharSequence)properties.get("clientInterfaceName");
        if (interfaceLibraryName == null || interfaceLibraryName.length() == 0) {
            interfaceLibraryName = "Vert.x";
        }
        int cltIntNameOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(interfaceLibraryName.length());
        int languageOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(0);
        String database = ((InitCommand)this.cmd).database();
        int databaseOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(database.length());
        content.writeIntLE(0);
        content.writeShortLE(0);
        int sspiOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(0);
        int atchDbFileOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(0);
        int changePasswordOffsetLengthIdx = content.writerIndex();
        content.writeShortLE(0);
        content.writeShortLE(0);
        content.writeIntLE(0);
        content.setShortLE(hostNameOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence((CharSequence)hostName, StandardCharsets.UTF_16LE);
        content.setShortLE(userNameOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence((CharSequence)userName, StandardCharsets.UTF_16LE);
        content.setShortLE(passwordOffsetLengthIdx, content.writerIndex() - startIdx);
        this.writePassword(content, password);
        content.setShortLE(appNameOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence(appName, StandardCharsets.UTF_16LE);
        content.setShortLE(serverNameOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence((CharSequence)serverName, StandardCharsets.UTF_16LE);
        content.setShortLE(unusedOffsetLengthIdx, content.writerIndex() - startIdx);
        content.setShortLE(cltIntNameOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence(interfaceLibraryName, StandardCharsets.UTF_16LE);
        content.setShortLE(languageOffsetLengthIdx, content.writerIndex() - startIdx);
        content.setShortLE(databaseOffsetLengthIdx, content.writerIndex() - startIdx);
        content.writeCharSequence((CharSequence)database, StandardCharsets.UTF_16LE);
        content.setShortLE(sspiOffsetLengthIdx, content.writerIndex() - startIdx);
        content.setShortLE(atchDbFileOffsetLengthIdx, content.writerIndex() - startIdx);
        content.setShortLE(changePasswordOffsetLengthIdx, content.writerIndex() - startIdx);
        content.setIntLE(startIdx, content.writerIndex() - startIdx);
        this.tdsMessageCodec.encoder().writeTdsMessage((short)16, content);
    }

    private void writePassword(ByteBuf payload, String password) {
        byte[] bytes = password.getBytes(StandardCharsets.UTF_16LE);
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            bytes[i] = (byte)((b >> 4 | (b & 0xF) << 4) ^ 0xA5);
        }
        payload.writeBytes(bytes);
    }

    @Override
    protected void handleLoginAck() {
        this.result = ((InitCommand)this.cmd).connection();
    }
}

