/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.MSSQLDatabaseMetadata;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.mssqlclient.impl.command.PreLoginCommand;
import io.vertx.mssqlclient.impl.protocol.client.prelogin.EncryptionOptionToken;
import io.vertx.mssqlclient.impl.protocol.client.prelogin.OptionToken;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.List;

class PreLoginCommandCodec
extends MSSQLCommandCodec<MSSQLDatabaseMetadata, PreLoginCommand> {
    PreLoginCommandCodec(TdsMessageCodec tdsMessageCodec, PreLoginCommand cmd) {
        super(tdsMessageCodec, cmd);
    }

    @Override
    void encode() {
        ByteBuf content = this.tdsMessageCodec.alloc().ioBuffer();
        List<OptionToken> optionTokens = ((PreLoginCommand)this.cmd).optionTokens();
        int totalLengthOfOptionsData = 0;
        int versionOptionTokenOffsetLengthIdx = 0;
        int encryptionOptionTokenOffsetLengthIdx = 0;
        for (OptionToken token : optionTokens) {
            totalLengthOfOptionsData += token.optionLength();
            content.writeByte((int)token.tokenType());
            switch (token.tokenType()) {
                case 0: {
                    versionOptionTokenOffsetLengthIdx = content.writerIndex();
                    break;
                }
                case 1: {
                    encryptionOptionTokenOffsetLengthIdx = content.writerIndex();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected token type");
                }
            }
            content.writeShort(0);
            content.writeShort(token.optionLength());
        }
        content.writeByte(255);
        for (OptionToken token : optionTokens) {
            this.encodeTokenData(token, content);
        }
        int totalLengthOfPayload = content.writerIndex();
        int offsetStart = totalLengthOfPayload - totalLengthOfOptionsData;
        block10: for (OptionToken token : optionTokens) {
            switch (token.tokenType()) {
                case 0: {
                    content.setShort(versionOptionTokenOffsetLengthIdx, offsetStart);
                    offsetStart += token.optionLength();
                    continue block10;
                }
                case 1: {
                    content.setShort(encryptionOptionTokenOffsetLengthIdx, offsetStart);
                    offsetStart += token.optionLength();
                    continue block10;
                }
            }
            throw new IllegalStateException("Unexpected token type");
        }
        this.tdsMessageCodec.encoder().writeTdsMessage((short)18, content);
    }

    private void encodeTokenData(OptionToken optionToken, ByteBuf payload) {
        switch (optionToken.tokenType()) {
            case 0: {
                payload.writeInt(0);
                payload.writeShort(0);
                break;
            }
            case 1: {
                payload.writeByte((int)((EncryptionOptionToken)optionToken).setting());
            }
        }
    }

    @Override
    void decode(ByteBuf payload) {
        short optionType;
        MSSQLDatabaseMetadata metadata = null;
        do {
            optionType = payload.readUnsignedByte();
            int offset = payload.readUnsignedShort();
            payload.skipBytes(2);
            if (optionType != 0) continue;
            payload.readerIndex(offset);
            short major = payload.readUnsignedByte();
            short minor = payload.readUnsignedByte();
            int build = payload.readUnsignedShort();
            metadata = new MSSQLDatabaseMetadata(String.format("%d.%d.%d", major, (int)minor, build), major, minor);
            break;
        } while (optionType != 255);
        this.completionHandler.handle((Object)CommandResponse.success(metadata));
    }
}

