/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.Promise;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.core.net.impl.SSLHelper;
import io.vertx.core.net.impl.SslHandshakeCompletionHandler;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.impl.MSSQLDatabaseMetadata;
import io.vertx.mssqlclient.impl.codec.TdsLoginSentCompletionHandler;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.mssqlclient.impl.codec.TdsPacketDecoder;
import io.vertx.mssqlclient.impl.codec.TdsSslHandshakeCodec;
import io.vertx.mssqlclient.impl.command.PreLoginCommand;
import io.vertx.mssqlclient.impl.command.PreLoginResponse;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.InitCommand;
import io.vertx.sqlclient.impl.command.QueryCommandBase;
import io.vertx.sqlclient.impl.command.SimpleQueryCommand;
import io.vertx.sqlclient.impl.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.Map;
import java.util.function.Predicate;

class MSSQLSocketConnection
extends SocketConnectionBase {
    private final int packetSize;
    private MSSQLDatabaseMetadata databaseMetadata;

    MSSQLSocketConnection(NetSocketInternal socket, int packetSize, boolean cachePreparedStatements, int preparedStatementCacheSize, Predicate<String> preparedStatementCacheSqlFilter, int pipeliningLimit, EventLoopContext context) {
        super(socket, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
        this.packetSize = packetSize;
    }

    Future<Byte> sendPreLoginMessage(boolean clientConfigSsl) {
        PreLoginCommand cmd = new PreLoginCommand(clientConfigSsl);
        return this.schedule((ContextInternal)this.context, cmd).onSuccess(resp -> this.setDatabaseMetadata(resp.metadata())).map(PreLoginResponse::encryptionLevel);
    }

    Future<Void> enableSsl(boolean clientConfigSsl, byte encryptionLevel, MSSQLConnectOptions options) {
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        PromiseInternal promise = this.context.promise();
        ChannelPromise p = pipeline.newPromise();
        pipeline.addFirst("handshaker", (ChannelHandler)new SslHandshakeCompletionHandler((Promise)p));
        p.addListener(future -> {
            if (future.isSuccess()) {
                pipeline.removeFirst();
                promise.complete();
            } else {
                promise.fail(future.cause());
            }
        });
        if (!clientConfigSsl) {
            options.setTrustAll(true);
        }
        SSLHelper helper = new SSLHelper((NetClientOptions)options, options.getKeyCertOptions(), options.getTrustOptions()).setApplicationProtocols(options.getApplicationLayerProtocols());
        SslHandler sslHandler = new SslHandler(helper.createEngine(this.context.owner(), this.socket.remoteAddress(), null, false));
        sslHandler.setHandshakeTimeout(helper.getSslHandshakeTimeout(), helper.getSslHandshakeTimeoutUnit());
        TdsSslHandshakeCodec tdsSslHandshakeCodec = new TdsSslHandshakeCodec();
        TdsLoginSentCompletionHandler tdsLoginSentCompletionHandler = new TdsLoginSentCompletionHandler(sslHandler, encryptionLevel);
        pipeline.addFirst("tds-ssl-handshake-codec", (ChannelHandler)tdsSslHandshakeCodec);
        pipeline.addAfter("tds-ssl-handshake-codec", "tds-login-sent-handler", (ChannelHandler)tdsLoginSentCompletionHandler);
        pipeline.addAfter("tds-login-sent-handler", "ssl", (ChannelHandler)sslHandler);
        return promise.future();
    }

    Future<Connection> sendLoginMessage(String username, String password, String database, Map<String, String> properties) {
        InitCommand cmd = new InitCommand((SocketConnectionBase)this, username, password, database, properties);
        return this.schedule((ContextInternal)this.context, (CommandBase)cmd);
    }

    public void init() {
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        pipeline.addBefore("handler", "messageCodec", (ChannelHandler)new TdsMessageCodec(this.packetSize));
        pipeline.addBefore("messageCodec", "packetDecoder", (ChannelHandler)new TdsPacketDecoder());
        super.init();
    }

    protected <R> void doSchedule(CommandBase<R> cmd, Handler<AsyncResult<R>> handler) {
        if (cmd instanceof TxCommand) {
            TxCommand tx = (TxCommand)cmd;
            String sql = tx.kind == TxCommand.Kind.BEGIN ? "BEGIN TRANSACTION" : tx.kind.sql;
            SimpleQueryCommand cmd2 = new SimpleQueryCommand(sql, false, false, QueryCommandBase.NULL_COLLECTOR, QueryResultHandler.NOOP_HANDLER);
            super.doSchedule((CommandBase)cmd2, ar -> handler.handle((Object)ar.map(tx.result)));
        } else {
            super.doSchedule(cmd, handler);
        }
    }

    public DatabaseMetadata getDatabaseMetaData() {
        return this.databaseMetadata;
    }

    private void setDatabaseMetadata(MSSQLDatabaseMetadata metadata) {
        this.databaseMetadata = metadata;
    }
}

