/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;

public class TdsSslHandshakeCodec
extends CombinedChannelDuplexHandler<ChannelInboundHandler, ChannelOutboundHandler> {
    public TdsSslHandshakeCodec() {
        this.init((ChannelInboundHandler)new Decoder(), (ChannelOutboundHandler)new Encoder());
    }

    private static class Encoder
    extends ChannelOutboundHandlerAdapter {
        private ByteBufAllocator alloc;
        private CompositeByteBuf accumulator;

        private Encoder() {
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            this.alloc = ctx.alloc();
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            if (this.accumulator != null) {
                this.accumulator.release();
            }
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ByteBuf) {
                this.accumulate((ByteBuf)msg);
                promise.setSuccess();
            } else {
                super.write(ctx, msg, promise);
            }
        }

        private void accumulate(ByteBuf byteBuf) {
            if (this.accumulator == null) {
                this.accumulator = this.alloc.compositeBuffer();
            }
            this.accumulator.addComponent(true, byteBuf.retainedSlice());
        }

        public void flush(ChannelHandlerContext ctx) throws Exception {
            if (this.accumulator != null) {
                ByteBuf header = this.alloc.ioBuffer(8);
                header.writeByte(18);
                header.writeByte(1);
                header.writeShort(8 + this.accumulator.writerIndex());
                header.writeZero(4);
                ctx.write((Object)header, ctx.voidPromise());
                ctx.writeAndFlush((Object)this.accumulator, ctx.voidPromise());
                this.accumulator = null;
            } else {
                ctx.flush();
            }
        }
    }

    private static class Decoder
    extends LengthFieldBasedFrameDecoder {
        Decoder() {
            super(Short.MAX_VALUE, 2, 2, -4, 0);
        }

        protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            ByteBuf byteBuf = (ByteBuf)super.decode(ctx, in);
            if (byteBuf == null) {
                return null;
            }
            int length = in.getUnsignedShort(2);
            return byteBuf.slice(8, length - 8);
        }
    }
}

