/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.utils;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;

public class ByteBufUtils {
    public static void writeByteLengthString(ByteBuf buffer, String value) {
        if (value == null) {
            buffer.writeByte(0);
        } else {
            buffer.writeByte(value.length());
            buffer.writeCharSequence((CharSequence)value, StandardCharsets.UTF_16LE);
        }
    }

    public static String readUnsignedByteLengthString(ByteBuf buffer) {
        short length = buffer.readUnsignedByte();
        return buffer.readCharSequence(length * 2, StandardCharsets.UTF_16LE).toString();
    }

    public static String readUnsignedShortLengthString(ByteBuf buffer) {
        int length = buffer.readUnsignedShortLE();
        return buffer.readCharSequence(length * 2, StandardCharsets.UTF_16LE).toString();
    }

    public static void writeUnsignedShortLengthString(ByteBuf buffer, String value) {
        buffer.writeShortLE(value.length() * 2);
        buffer.writeCharSequence((CharSequence)value, StandardCharsets.UTF_16LE);
    }

    public static long readUnsignedInt40LE(ByteBuf buffer) {
        long low = buffer.readUnsignedIntLE();
        short high = buffer.readUnsignedByte();
        return 0x100000000L * (long)high + low;
    }

    public static void writeUnsignedInt40LE(ByteBuf buffer, long value) {
        buffer.writeIntLE((int)(value % 0x100000000L));
        buffer.writeByte((int)(value / 0x100000000L));
    }

    private ByteBufUtils() {
    }
}

