/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLConnection;
import io.vertx.mssqlclient.impl.MSSQLConnectionFactory;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;

public class MSSQLConnectionImpl
extends SqlConnectionImpl<MSSQLConnectionImpl>
implements MSSQLConnection {
    public MSSQLConnectionImpl(ContextInternal context, ConnectionFactory factory, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(context, factory, conn, tracer, metrics);
    }

    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append('@').append('P').append(1 + index);
        return index;
    }

    public static Future<MSSQLConnection> connect(Vertx vertx, MSSQLConnectOptions options) {
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        MSSQLConnectionFactory client = new MSSQLConnectionFactory(ctx.owner(), options);
        ctx.addCloseHook((Closeable)client);
        return client.connect((Context)ctx);
    }
}

