/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.spi.MSSQLDriver;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

@VertxGen
public interface MSSQLPool
extends Pool {
    public static MSSQLPool pool(String connectionUri) {
        return MSSQLPool.pool(connectionUri, new PoolOptions());
    }

    public static MSSQLPool pool(String connectionUri, PoolOptions options) {
        return MSSQLPool.pool(MSSQLConnectOptions.fromUri(connectionUri), options);
    }

    public static MSSQLPool pool(Vertx vertx, String connectionUri) {
        return MSSQLPool.pool(vertx, MSSQLConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static MSSQLPool pool(Vertx vertx, String connectionUri, PoolOptions options) {
        return MSSQLPool.pool(vertx, MSSQLConnectOptions.fromUri(connectionUri), options);
    }

    public static MSSQLPool pool(MSSQLConnectOptions database, PoolOptions options) {
        return MSSQLPool.pool(null, database, options);
    }

    public static MSSQLPool pool(Vertx vertx, MSSQLConnectOptions database, PoolOptions options) {
        return MSSQLPool.pool(vertx, Collections.singletonList(database), options);
    }

    public static MSSQLPool pool(List<MSSQLConnectOptions> databases, PoolOptions options) {
        return MSSQLPool.pool(null, databases, options);
    }

    public static MSSQLPool pool(Vertx vertx, List<MSSQLConnectOptions> databases, PoolOptions options) {
        return new MSSQLDriver().createPool(vertx, databases, options);
    }

    public MSSQLPool connectHandler(Handler<SqlConnection> var1);

    @Fluent
    public MSSQLPool connectionProvider(Function<Context, Future<SqlConnection>> var1);
}

