/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.mssqlclient.impl.utils.ByteBufUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.sql.JDBCType;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public enum DataType {
    NULL(31){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public String paramDefinition(Object value) {
            return "nvarchar(4000)";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
        }
    }
    ,
    INT1(48){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.TINYINT;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return byteBuf.readUnsignedByte();
        }
    }
    ,
    BIT(50){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.BOOLEAN;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return byteBuf.readBoolean();
        }
    }
    ,
    INT2(52){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.SMALLINT;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return byteBuf.readShortLE();
        }
    }
    ,
    INT4(56){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.INTEGER;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return byteBuf.readIntLE();
        }
    }
    ,
    DATETIM4(58){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.TIMESTAMP;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return this.decodeUnsignedShortDateValue(byteBuf);
        }

        @Override
        public String paramDefinition(Object value) {
            return "smalldatetime";
        }
    }
    ,
    FLT4(59){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.REAL;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return Float.valueOf(byteBuf.readFloatLE());
        }
    }
    ,
    MONEY(60){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            long highBits = (long)byteBuf.readIntLE() << 32;
            long lowBits = (long)byteBuf.readIntLE() & 0xFFFFFFFFL;
            BigInteger bigInteger = BigInteger.valueOf(highBits | lowBits);
            return new BigDecimal(bigInteger).divide(new BigDecimal("10000"), 4, RoundingMode.UP);
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.DECIMAL;
        }
    }
    ,
    DATETIME(61){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.TIMESTAMP;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return this.decodeIntLEDateValue(byteBuf);
        }
    }
    ,
    FLT8(62){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.DOUBLE;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return byteBuf.readDoubleLE();
        }
    }
    ,
    MONEY4(122){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return new BigDecimal(byteBuf.readIntLE()).divide(new BigDecimal("10000"), 2, RoundingMode.UP);
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.DECIMAL;
        }
    }
    ,
    INT8(127){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.BIGINT;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return byteBuf.readLongLE();
        }
    }
    ,
    DECIMAL(55),
    NUMERIC(63),
    GUID(36),
    INTN(38){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.length = byteBuf.readByte();
            return metadata;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            if (metadata.length == 1) {
                return JDBCType.TINYINT;
            }
            if (metadata.length == 2) {
                return JDBCType.SMALLINT;
            }
            if (metadata.length == 4) {
                return JDBCType.INTEGER;
            }
            if (metadata.length == 8) {
                return JDBCType.BIGINT;
            }
            throw new IllegalArgumentException("Invalid length: " + metadata.length);
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            if (length == 1) {
                return byteBuf.readUnsignedByte();
            }
            if (length == 2) {
                return byteBuf.readShortLE();
            }
            if (length == 4) {
                return byteBuf.readIntLE();
            }
            if (length == 8) {
                return byteBuf.readLongLE();
            }
            throw new IllegalArgumentException("Invalid length: " + length);
        }

        @Override
        public String paramDefinition(Object value) {
            return "bigint";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            if (value instanceof Byte) {
                Byte bValue = (Byte)value;
                byteBuf.writeByte(1);
                byteBuf.writeByte(1);
                byteBuf.writeByte((int)bValue.byteValue());
            } else if (value instanceof Short) {
                Short sValue = (Short)value;
                byteBuf.writeByte(2);
                byteBuf.writeByte(2);
                byteBuf.writeShortLE((int)sValue.shortValue());
            } else if (value instanceof Integer) {
                Integer iValue = (Integer)value;
                byteBuf.writeByte(4);
                byteBuf.writeByte(4);
                byteBuf.writeIntLE(iValue.intValue());
            } else if (value instanceof Long) {
                Long lValue = (Long)value;
                byteBuf.writeByte(8);
                byteBuf.writeByte(8);
                byteBuf.writeLongLE(lValue.longValue());
            } else {
                throw new IllegalArgumentException(value.getClass().getName());
            }
        }
    }
    ,
    BITN(104){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.length = byteBuf.readByte();
            return metadata;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.BOOLEAN;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            if (length == 1) {
                return byteBuf.readBoolean();
            }
            throw new IllegalArgumentException("Invalid length: " + length);
        }

        @Override
        public String paramDefinition(Object value) {
            return "bit";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, 14.BITN.id);
            byteBuf.writeByte(1);
            byteBuf.writeByte(1);
            byteBuf.writeBoolean(((Boolean)value).booleanValue());
        }
    }
    ,
    DECIMALN(106){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.length = byteBuf.readUnsignedByte();
            metadata.precision = byteBuf.readByte();
            metadata.scale = byteBuf.readByte();
            return metadata;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.DECIMAL;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            short length = byteBuf.readUnsignedByte();
            if (length == 0) {
                return null;
            }
            byte sign = byteBuf.readByte();
            byte[] bytes = new byte[length - 1];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = byteBuf.getByte(byteBuf.readerIndex() + bytes.length - 1 - i);
            }
            byteBuf.skipBytes(bytes.length);
            BigInteger bigInteger = new BigInteger(bytes);
            BigDecimal bigDecimal = new BigDecimal(bigInteger, metadata.scale);
            return sign == 0 ? bigDecimal.negate() : bigDecimal;
        }

        @Override
        public String paramDefinition(Object value) {
            return "numeric(38," + (value == null ? 0 : Math.max(0, ((BigDecimal)value).scale())) + ")";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            BigDecimal bigDecimal = (BigDecimal)value;
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            byteBuf.writeByte(17);
            byteBuf.writeByte(38);
            int sign = bigDecimal.signum() < 0 ? 0 : 1;
            byte[] bytes = (sign == 0 ? bigDecimal.negate() : bigDecimal).unscaledValue().toByteArray();
            byteBuf.writeByte(Math.max(0, bigDecimal.scale()));
            byteBuf.writeByte(1 + bytes.length);
            byteBuf.writeByte(sign);
            for (int i = bytes.length - 1; i >= 0; --i) {
                byteBuf.writeByte((int)bytes[i]);
            }
        }
    }
    ,
    NUMERICN(108){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return DECIMALN.decodeMetadata(byteBuf);
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.DECIMAL;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return DECIMALN.decodeValue(byteBuf, metadata);
        }
    }
    ,
    FLTN(109){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.length = byteBuf.readByte();
            return metadata;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            if (metadata.length == 4) {
                return JDBCType.REAL;
            }
            if (metadata.length == 8) {
                return JDBCType.DOUBLE;
            }
            throw new IllegalArgumentException("Invalid length: " + metadata.length);
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            if (length == 4) {
                return Float.valueOf(byteBuf.readFloatLE());
            }
            if (length == 8) {
                return byteBuf.readDoubleLE();
            }
            throw new IllegalArgumentException("Invalid length: " + length);
        }

        @Override
        public String paramDefinition(Object value) {
            return "float";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            if (value instanceof Float) {
                Float fValue = (Float)value;
                byteBuf.writeByte(4);
                byteBuf.writeByte(4);
                byteBuf.writeFloatLE(fValue.floatValue());
            } else if (value instanceof Double) {
                Double dValue = (Double)value;
                byteBuf.writeByte(8);
                byteBuf.writeByte(8);
                byteBuf.writeDoubleLE(dValue.doubleValue());
            } else {
                throw new IllegalArgumentException();
            }
        }
    }
    ,
    MONEYN(110){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.scale = byteBuf.readByte();
            return metadata;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            if (length == 4) {
                return MONEY4.decodeValue(byteBuf, metadata);
            }
            if (length == 8) {
                return MONEY.decodeValue(byteBuf, metadata);
            }
            throw new IllegalArgumentException("Invalid length: " + length);
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.DECIMAL;
        }
    }
    ,
    DATETIMN(111){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.scale = byteBuf.readByte();
            return metadata;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.TIMESTAMP;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            if (length == 8) {
                return this.decodeIntLEDateValue(byteBuf);
            }
            if (length == 4) {
                return this.decodeUnsignedShortDateValue(byteBuf);
            }
            throw new UnsupportedOperationException("Invalid length for date " + this.name());
        }

        @Override
        public String paramDefinition(Object value) {
            return "datetime";
        }
    }
    ,
    DATEN(40){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return null;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.DATE;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            return DataType.decodeLocalDate(byteBuf, length);
        }

        @Override
        public String paramDefinition(Object value) {
            return "date";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            byteBuf.writeByte(3);
            byteBuf.writeMediumLE(DataType.daysFromStartDate((LocalDate)value));
        }
    }
    ,
    TIMEN(41){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.scale = byteBuf.readByte();
            return metadata;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.TIME;
        }

        @Override
        public String paramDefinition(Object value) {
            return "time";
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            return DataType.decodeLocalTime(byteBuf, length, metadata.scale);
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            byteBuf.writeByte(7);
            byteBuf.writeByte(5);
            ByteBufUtils.writeUnsignedInt40LE(byteBuf, DataType.hundredsOfNanos((LocalTime)value));
        }
    }
    ,
    DATETIME2N(42){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.scale = byteBuf.readByte();
            return metadata;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.TIMESTAMP;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            LocalTime localTime = DataType.decodeLocalTime(byteBuf, length - 3, metadata.scale);
            LocalDate localDate = DataType.decodeLocalDate(byteBuf, 3);
            return LocalDateTime.of(localDate, localTime);
        }

        @Override
        public String paramDefinition(Object value) {
            return "datetime2";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            byteBuf.writeByte(7);
            byteBuf.writeByte(8);
            ByteBufUtils.writeUnsignedInt40LE(byteBuf, DataType.hundredsOfNanos(localDateTime.toLocalTime()));
            byteBuf.writeMediumLE(DataType.daysFromStartDate(localDateTime.toLocalDate()));
        }
    }
    ,
    DATETIMEOFFSETN(43){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.scale = byteBuf.readByte();
            return metadata;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.TIMESTAMP_WITH_TIMEZONE;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            byte length = byteBuf.readByte();
            if (length == 0) {
                return null;
            }
            LocalTime localTime = DataType.decodeLocalTime(byteBuf, length - 5, metadata.scale);
            LocalDate localDate = DataType.decodeLocalDate(byteBuf, 3);
            short minutes = byteBuf.readShortLE();
            return LocalDateTime.of(localDate, localTime).plusMinutes(minutes).atOffset(ZoneOffset.ofTotalSeconds(60 * minutes));
        }

        @Override
        public String paramDefinition(Object value) {
            return "datetimeoffset";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            OffsetDateTime offsetDateTime = (OffsetDateTime)value;
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            byteBuf.writeByte(7);
            byteBuf.writeByte(10);
            int offsetMinutes = offsetDateTime.getOffset().getTotalSeconds() / 60;
            LocalDateTime localDateTime = offsetDateTime.toLocalDateTime().minusMinutes(offsetMinutes);
            ByteBufUtils.writeUnsignedInt40LE(byteBuf, DataType.hundredsOfNanos(localDateTime.toLocalTime()));
            byteBuf.writeMediumLE(DataType.daysFromStartDate(localDateTime.toLocalDate()));
            byteBuf.writeShortLE(offsetMinutes);
        }
    }
    ,
    CHAR(47),
    VARCHAR(39),
    BINARY(45){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return BIGVARBINARY.decodeMetadata(byteBuf);
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.BINARY;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return BIGVARBINARY.decodeValue(byteBuf, metadata);
        }
    }
    ,
    VARBINARY(37){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return BIGVARBINARY.decodeMetadata(byteBuf);
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.VARBINARY;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return BIGVARBINARY.decodeValue(byteBuf, metadata);
        }
    }
    ,
    BIGVARBINARY(165){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.length = byteBuf.readUnsignedShortLE();
            return metadata;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.LONGVARBINARY;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            int length = byteBuf.readUnsignedShortLE();
            ByteBuf res = Unpooled.buffer((int)length);
            byteBuf.readBytes(res, 0, length);
            res.writerIndex(length);
            return Buffer.buffer((ByteBuf)res);
        }

        @Override
        public String paramDefinition(Object value) {
            return "binary(" + (value == null ? 1 : ((Buffer)value).length()) + ")";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            Buffer buffer = (Buffer)value;
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            byteBuf.writeShortLE(buffer.length());
            byteBuf.writeShortLE(buffer.length());
            byteBuf.writeBytes(buffer.getByteBuf());
        }
    }
    ,
    BIGVARCHAR(167){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.length = byteBuf.readUnsignedShortLE();
            byteBuf.skipBytes(2);
            byteBuf.skipBytes(2);
            byteBuf.skipBytes(1);
            return metadata;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.VARCHAR;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            int length = byteBuf.readUnsignedShortLE();
            if (length == 65535) {
                return null;
            }
            return byteBuf.readCharSequence(length, StandardCharsets.UTF_8);
        }
    }
    ,
    BIGBINARY(173){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return BIGVARBINARY.decodeMetadata(byteBuf);
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.BINARY;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return BIGVARBINARY.decodeValue(byteBuf, metadata);
        }
    }
    ,
    BIGCHAR(175){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return BIGVARCHAR.decodeMetadata(byteBuf);
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return BIGVARCHAR.jdbcType(metadata);
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return BIGVARCHAR.decodeValue(byteBuf, metadata);
        }
    }
    ,
    NVARCHAR(231){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            Metadata metadata = new Metadata();
            metadata.length = byteBuf.readUnsignedShortLE();
            byteBuf.skipBytes(2);
            byteBuf.skipBytes(2);
            byteBuf.skipBytes(1);
            return metadata;
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return JDBCType.VARCHAR;
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            int length = byteBuf.readUnsignedShortLE();
            if (length == 65535) {
                return null;
            }
            return byteBuf.readCharSequence(length, StandardCharsets.UTF_16LE);
        }

        @Override
        public String paramDefinition(Object value) {
            return "nvarchar(4000)";
        }

        @Override
        public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
            DataType.writeParamDescription(byteBuf, name, out, this.id);
            byteBuf.writeShortLE(8000);
            byteBuf.writeByte(9);
            byteBuf.writeByte(4);
            byteBuf.writeByte(208);
            byteBuf.writeByte(0);
            byteBuf.writeByte(52);
            ByteBufUtils.writeUnsignedShortLengthString(byteBuf, value instanceof Enum ? ((Enum)value).name() : value.toString());
        }
    }
    ,
    NCHAR(239){

        @Override
        public Metadata decodeMetadata(ByteBuf byteBuf) {
            return NVARCHAR.decodeMetadata(byteBuf);
        }

        @Override
        public JDBCType jdbcType(Metadata metadata) {
            return NVARCHAR.jdbcType(metadata);
        }

        @Override
        public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
            return NVARCHAR.decodeValue(byteBuf, metadata);
        }
    }
    ,
    XML(241),
    UDT(240),
    TEXT(35),
    IMAGE(34),
    NTEXT(99),
    SSVARIANT(98);

    public final int id;
    private static final LocalDate START_DATE;
    private static final LocalDate START_DATE_DATETIME;
    private static final IntObjectMap<DataType> typesById;
    private static final Map<Class<?>, DataType> typesByValueClass;

    private DataType(int id) {
        this.id = id;
    }

    public LocalDateTime decodeIntLEDateValue(ByteBuf byteBuf) {
        LocalDate localDate = START_DATE_DATETIME.plus(byteBuf.readIntLE(), ChronoUnit.DAYS);
        long nanoOfDay = TimeUnit.NANOSECONDS.convert(Math.round((double)byteBuf.readIntLE() * 3.3333333333333335), TimeUnit.MILLISECONDS);
        LocalTime localTime = LocalTime.ofNanoOfDay(nanoOfDay);
        return LocalDateTime.of(localDate, localTime);
    }

    public LocalDateTime decodeUnsignedShortDateValue(ByteBuf byteBuf) {
        LocalDate localDate = START_DATE_DATETIME.plus(byteBuf.readUnsignedShortLE(), ChronoUnit.DAYS);
        LocalTime localTime = LocalTime.ofSecondOfDay((long)byteBuf.readUnsignedShortLE() * 60L);
        return LocalDateTime.of(localDate, localTime);
    }

    public Metadata decodeMetadata(ByteBuf byteBuf) {
        throw new UnsupportedOperationException("Unable to decode metadata for " + this.name());
    }

    public JDBCType jdbcType(Metadata metadata) {
        throw new UnsupportedOperationException("Unable to determine jdbc type for " + this.name());
    }

    public Object decodeValue(ByteBuf byteBuf, Metadata metadata) {
        throw new UnsupportedOperationException("Unable to decode value for " + this.name());
    }

    public String paramDefinition(Object value) {
        throw new UnsupportedOperationException("Unable to generate param definition for " + this.name());
    }

    public void encodeParam(ByteBuf byteBuf, String name, boolean out, Object value) {
        throw new UnsupportedOperationException("Unable to encode param for " + this.name());
    }

    public static DataType forId(int id) {
        DataType dataType = (DataType)((Object)typesById.get(id));
        if (dataType == null) {
            throw new IllegalArgumentException("Unknown data type: " + id);
        }
        return dataType;
    }

    public static DataType forValueClass(Class<?> valueClass) {
        DataType dataType = Buffer.class.isAssignableFrom(valueClass) ? typesByValueClass.get(Buffer.class) : (valueClass.isEnum() ? typesByValueClass.get(String.class) : typesByValueClass.get(valueClass));
        if (dataType == null) {
            throw new IllegalArgumentException("Unsupported value class: " + valueClass);
        }
        return dataType;
    }

    private static void writeParamDescription(ByteBuf buffer, String name, boolean out, int id) {
        ByteBufUtils.writeByteLengthString(buffer, name);
        buffer.writeByte(out ? 1 : 0);
        buffer.writeByte(id);
    }

    private static LocalDate decodeLocalDate(ByteBuf byteBuf, int length) {
        if (length == 3) {
            int days = byteBuf.readUnsignedMediumLE();
            return START_DATE.plus(days, ChronoUnit.DAYS);
        }
        throw new IllegalArgumentException("Invalid length: " + length);
    }

    private static LocalTime decodeLocalTime(ByteBuf byteBuf, int length, int scale) {
        long hundredNanos;
        if (length == 3) {
            hundredNanos = byteBuf.readUnsignedMediumLE();
        } else if (length == 4) {
            hundredNanos = byteBuf.readUnsignedIntLE();
        } else if (length == 5) {
            hundredNanos = ByteBufUtils.readUnsignedInt40LE(byteBuf);
        } else {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        for (int i = scale; i < 7; ++i) {
            hundredNanos *= 10L;
        }
        return LocalTime.ofNanoOfDay(100L * hundredNanos);
    }

    private static int daysFromStartDate(LocalDate localDate) {
        return (int)ChronoUnit.DAYS.between(START_DATE, localDate);
    }

    private static long hundredsOfNanos(LocalTime localTime) {
        return localTime.toNanoOfDay() / 100L;
    }

    static {
        START_DATE = LocalDate.of(1, 1, 1);
        START_DATE_DATETIME = LocalDate.of(1900, 1, 1);
        typesById = new IntObjectHashMap(DataType.values().length);
        for (DataType dataType : DataType.values()) {
            typesById.put(dataType.id, (Object)dataType);
        }
        typesByValueClass = new HashMap();
        typesByValueClass.put(Byte.class, INTN);
        typesByValueClass.put(Short.class, INTN);
        typesByValueClass.put(Integer.class, INTN);
        typesByValueClass.put(Long.class, INTN);
        typesByValueClass.put(Boolean.class, BITN);
        typesByValueClass.put(Float.class, FLTN);
        typesByValueClass.put(Double.class, FLTN);
        typesByValueClass.put(BigDecimal.class, DECIMALN);
        typesByValueClass.put(String.class, NVARCHAR);
        typesByValueClass.put(LocalDate.class, DATEN);
        typesByValueClass.put(LocalTime.class, TIMEN);
        typesByValueClass.put(LocalDateTime.class, DATETIME2N);
        typesByValueClass.put(OffsetDateTime.class, DATETIMEOFFSETN);
        typesByValueClass.put(Buffer.class, BIGVARBINARY);
    }

    public static class Metadata {
        private int length;
        private byte precision;
        private byte scale;

        public int length() {
            return this.length;
        }

        public byte precision() {
            return this.precision;
        }

        public byte scale() {
            return this.scale;
        }

        public String toString() {
            return "Metadata{length=" + this.length + ", precision=" + this.precision + ", scale=" + this.scale + '}';
        }
    }
}

