/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.MSSQLRowImpl;
import io.vertx.mssqlclient.impl.codec.ColumnData;
import io.vertx.mssqlclient.impl.codec.MSSQLRowDesc;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.RowDecoder;
import java.util.stream.Collector;

class RowResultDecoder<C, R>
extends RowDecoder<C, R> {
    final MSSQLRowDesc desc;
    private RowStreamTokenType handleType = RowStreamTokenType.ROW;

    RowResultDecoder(Collector<Row, C, R> collector, MSSQLRowDesc desc) {
        super(collector);
        this.desc = desc;
    }

    public Row decodeRow(int len, ByteBuf in) {
        switch (this.handleType) {
            case ROW: {
                return this.decodeMssqlRow(len, in);
            }
            case NBCROW: {
                return this.decodeMssqlNbcRow(len, in);
            }
        }
        throw new UnsupportedOperationException("Unknown row stream token type");
    }

    public void handleRow(int len, ByteBuf in) {
        this.handleType = RowStreamTokenType.ROW;
        super.handleRow(len, in);
    }

    public void handleNbcRow(int len, ByteBuf in) {
        this.handleType = RowStreamTokenType.NBCROW;
        super.handleRow(len, in);
    }

    private Row decodeMssqlRow(int len, ByteBuf in) {
        MSSQLRowImpl row = new MSSQLRowImpl(this.desc);
        for (int c = 0; c < len; ++c) {
            ColumnData columnData = this.desc.columnDatas[c];
            row.addValue(columnData.dataType().decodeValue(in, columnData.metadata()));
        }
        return row;
    }

    private Row decodeMssqlNbcRow(int len, ByteBuf in) {
        MSSQLRowImpl row = new MSSQLRowImpl(this.desc);
        int nullBitmapByteCount = (len - 1 >> 3) + 1;
        int nullBitMapStartIdx = in.readerIndex();
        in.skipBytes(nullBitmapByteCount);
        for (int c = 0; c < len; ++c) {
            int bytePos = c >> 3;
            int bitPos = c & 7;
            byte mask = (byte)(1 << bitPos);
            byte nullByte = in.getByte(nullBitMapStartIdx + bytePos);
            Object decoded = null;
            if ((nullByte & mask) == 0) {
                ColumnData columnData = this.desc.columnDatas[c];
                decoded = columnData.dataType().decodeValue(in, columnData.metadata());
            }
            row.addValue(decoded);
        }
        return row;
    }

    static enum RowStreamTokenType {
        ROW,
        NBCROW,
        ALTROW;

    }
}

