/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Handler;
import io.vertx.mssqlclient.MSSQLException;
import io.vertx.mssqlclient.MSSQLInfo;
import io.vertx.mssqlclient.impl.codec.ColumnData;
import io.vertx.mssqlclient.impl.codec.DataType;
import io.vertx.mssqlclient.impl.codec.MSSQLRowDesc;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.mssqlclient.impl.codec.TypeInfo;
import io.vertx.mssqlclient.impl.utils.ByteBufUtils;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;

abstract class MSSQLCommandCodec<R, C extends CommandBase<R>> {
    protected final TdsMessageCodec tdsMessageCodec;
    final C cmd;
    public MSSQLException failure;
    public R result;
    Handler<? super CommandResponse<R>> completionHandler;

    MSSQLCommandCodec(TdsMessageCodec tdsMessageCodec, C cmd) {
        this.tdsMessageCodec = tdsMessageCodec;
        this.cmd = cmd;
    }

    abstract void encode();

    void decode(ByteBuf payload) {
        block13: while (payload.isReadable()) {
            short tokenType = payload.readUnsignedByte();
            switch (tokenType) {
                case 173: {
                    payload.skipBytes(payload.readUnsignedShortLE());
                    this.handleLoginAck();
                    continue block13;
                }
                case 129: {
                    this.handleColumnMetadata(payload);
                    continue block13;
                }
                case 209: {
                    this.handleRow(payload);
                    continue block13;
                }
                case 210: {
                    this.handleNbcRow(payload);
                    continue block13;
                }
                case 253: 
                case 254: 
                case 255: {
                    this.handleDone(tokenType, payload);
                    continue block13;
                }
                case 171: {
                    this.handleInfo(payload);
                    continue block13;
                }
                case 164: 
                case 165: 
                case 169: {
                    payload.skipBytes(payload.readUnsignedShortLE());
                    continue block13;
                }
                case 121: {
                    payload.skipBytes(4);
                    continue block13;
                }
                case 172: {
                    this.handleReturnValue(payload);
                    continue block13;
                }
                case 170: {
                    this.handleError(payload);
                    continue block13;
                }
                case 227: {
                    this.handleEnvChange(payload);
                    continue block13;
                }
            }
            throw new UnsupportedOperationException("Unsupported token: 0x" + Integer.toHexString(tokenType));
        }
        this.handleDecodingComplete();
    }

    protected void handleInfo(ByteBuf payload) {
        payload.skipBytes(2);
        MSSQLInfo info = new MSSQLInfo().setNumber(payload.readIntLE()).setState(payload.readByte()).setSeverity(payload.readByte()).setMessage(ByteBufUtils.readUnsignedShortLengthString(payload)).setServerName(ByteBufUtils.readUnsignedByteLengthString(payload)).setProcedureName(ByteBufUtils.readUnsignedByteLengthString(payload)).setLineNumber(payload.readIntLE());
        this.tdsMessageCodec.chctx().fireChannelRead((Object)info);
    }

    protected void handleLoginAck() {
    }

    private void handleColumnMetadata(ByteBuf payload) {
        int columnCount = payload.readUnsignedShortLE();
        if (columnCount == 65535) {
            return;
        }
        ColumnData[] columnDatas = new ColumnData[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            payload.skipBytes(6);
            DataType dataType = DataType.forId(payload.readUnsignedByte());
            TypeInfo metadata = dataType.decodeTypeInfo(payload);
            String columnName = ByteBufUtils.readUnsignedByteLengthString(payload);
            columnDatas[i] = new ColumnData(columnName, dataType, metadata);
        }
        this.handleRowDesc(this.createRowDesc(columnDatas));
    }

    protected MSSQLRowDesc createRowDesc(ColumnData[] columnData) {
        return MSSQLRowDesc.create(columnData, false);
    }

    protected void handleRowDesc(MSSQLRowDesc mssqlRowDesc) {
    }

    protected void handleRow(ByteBuf payload) {
    }

    protected void handleNbcRow(ByteBuf payload) {
    }

    private void handleDone(short tokenType, ByteBuf content) {
        short status = content.readShortLE();
        if ((status & 0x10) != 0) {
            content.skipBytes(2);
            this.handleAffectedRows(content.readLongLE());
        } else {
            content.skipBytes(10);
        }
        this.handleDone(tokenType);
    }

    protected void handleAffectedRows(long count) {
    }

    protected void handleDone(short tokenType) {
    }

    protected void handleReturnValue(ByteBuf payload) {
    }

    private void handleError(ByteBuf buffer) {
        buffer.skipBytes(2);
        int number = buffer.readIntLE();
        byte state = buffer.readByte();
        byte severity = buffer.readByte();
        String message = ByteBufUtils.readUnsignedShortLengthString(buffer);
        String serverName = ByteBufUtils.readUnsignedByteLengthString(buffer);
        String procedureName = ByteBufUtils.readUnsignedByteLengthString(buffer);
        int lineNumber = buffer.readIntLE();
        MSSQLException failure = new MSSQLException(number, state, severity, message, serverName, procedureName, lineNumber);
        if (this.failure == null) {
            this.failure = failure;
        } else {
            this.failure.add(failure);
        }
    }

    private void handleEnvChange(ByteBuf payload) {
        int totalLength = payload.readUnsignedShortLE();
        int startPos = payload.readerIndex();
        short type = payload.readUnsignedByte();
        switch (type) {
            case 4: {
                this.tdsMessageCodec.encoder().setPacketSize(Integer.parseInt(ByteBufUtils.readUnsignedByteLengthString(payload)));
                break;
            }
            case 8: 
            case 11: {
                if (payload.readUnsignedByte() != 8) {
                    throw new IllegalStateException();
                }
                this.tdsMessageCodec.setTransactionDescriptor(payload.readLongLE());
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                this.tdsMessageCodec.setTransactionDescriptor(0L);
                break;
            }
            case 20: {
                this.handleRouting(payload);
                break;
            }
        }
        payload.readerIndex(startPos + totalLength);
    }

    protected void handleRouting(ByteBuf payload) {
    }

    protected void handleDecodingComplete() {
        this.complete();
    }

    void complete() {
        CommandResponse resp = this.failure != null ? CommandResponse.failure((Throwable)this.failure) : CommandResponse.success(this.result);
        this.completionHandler.handle((Object)resp);
    }
}

