/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient;

import java.util.ArrayList;
import java.util.List;

public class MSSQLException
extends RuntimeException {
    private final int number;
    private final byte state;
    private final byte severity;
    private final String message;
    private final String serverName;
    private final String procedureName;
    private final int lineNumber;
    private List<MSSQLException> additional;

    public MSSQLException(int number, byte state, byte severity, String message, String serverName, String procedureName, int lineNumber) {
        super(null, null, false, false);
        this.number = number;
        this.state = state;
        this.severity = severity;
        this.message = message;
        this.serverName = serverName;
        this.procedureName = procedureName;
        this.lineNumber = lineNumber;
    }

    public void add(MSSQLException e) {
        if (this.additional == null) {
            this.additional = new ArrayList<MSSQLException>(3);
        }
        this.additional.add(e);
    }

    public int number() {
        return this.number;
    }

    public byte state() {
        return this.state;
    }

    public byte severity() {
        return this.severity;
    }

    public String errorMessage() {
        return this.message;
    }

    public String serverName() {
        return this.serverName;
    }

    public String procedureName() {
        return this.procedureName;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("{").append("number=").append(this.number).append(", state=").append(this.state).append(", severity=").append(this.severity);
        if (this.message != null && !this.message.isEmpty()) {
            sb.append(", message='").append(this.message).append('\'');
        }
        if (this.serverName != null && !this.serverName.isEmpty()) {
            sb.append(", serverName='").append(this.serverName).append('\'');
        }
        if (this.procedureName != null && !this.procedureName.isEmpty()) {
            sb.append(", procedureName='").append(this.procedureName).append('\'');
        }
        sb.append(", lineNumber=").append(this.lineNumber);
        if (this.additional != null) {
            sb.append(", additional=").append(this.additional);
        }
        return sb.append('}').toString();
    }
}

