/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLConnection;
import io.vertx.mssqlclient.MSSQLInfo;
import io.vertx.mssqlclient.impl.MSSQLConnectionFactory;
import io.vertx.mssqlclient.spi.MSSQLDriver;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.SqlConnectionBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;

public class MSSQLConnectionImpl
extends SqlConnectionBase<MSSQLConnectionImpl>
implements MSSQLConnection {
    private volatile Handler<MSSQLInfo> infoHandler;

    public MSSQLConnectionImpl(ContextInternal context, ConnectionFactory factory, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        super(context, factory, conn, (Driver)MSSQLDriver.INSTANCE, tracer, metrics);
    }

    public static Future<MSSQLConnection> connect(Vertx vertx, MSSQLConnectOptions options) {
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        MSSQLConnectionFactory client = new MSSQLConnectionFactory(ctx.owner(), options);
        ctx.addCloseHook((Closeable)client);
        return client.connect((Context)ctx);
    }

    public void handleEvent(Object event) {
        Handler<MSSQLInfo> handler = this.infoHandler;
        MSSQLInfo info = (MSSQLInfo)event;
        if (handler != null) {
            handler.handle((Object)info);
        } else {
            SocketConnectionBase.logger.warn(event);
        }
    }

    @Override
    public MSSQLConnection infoHandler(Handler<MSSQLInfo> handler) {
        this.infoHandler = handler;
        return this;
    }
}

