/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.spi;

import io.vertx.core.Closeable;
import io.vertx.core.Vertx;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.MSSQLPool;
import io.vertx.mssqlclient.impl.MSSQLConnectionFactory;
import io.vertx.mssqlclient.impl.MSSQLConnectionImpl;
import io.vertx.mssqlclient.impl.MSSQLConnectionUriParser;
import io.vertx.mssqlclient.impl.MSSQLPoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PoolImpl;
import io.vertx.sqlclient.impl.SqlConnectionInternal;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;
import java.util.List;
import java.util.stream.Collectors;

public class MSSQLDriver
implements Driver {
    private static final String SHARED_CLIENT_KEY = "__vertx.shared.mssqlclient";
    public static final MSSQLDriver INSTANCE = new MSSQLDriver();

    public MSSQLPool newPool(Vertx vertx, List<? extends SqlConnectOptions> databases, PoolOptions options, CloseFuture closeFuture) {
        VertxInternal vx = (VertxInternal)vertx;
        PoolImpl pool = options.isShared() ? (PoolImpl)vx.createSharedClient(SHARED_CLIENT_KEY, options.getName(), closeFuture, cf -> this.newPoolImpl(vx, databases, options, (CloseFuture)cf)) : this.newPoolImpl(vx, databases, options, closeFuture);
        return new MSSQLPoolImpl(vx, closeFuture, (Pool)pool);
    }

    private PoolImpl newPoolImpl(VertxInternal vertx, List<? extends SqlConnectOptions> databases, PoolOptions options, CloseFuture closeFuture) {
        MSSQLConnectOptions baseConnectOptions = MSSQLConnectOptions.wrap(databases.get(0));
        QueryTracer tracer = vertx.tracer() == null ? null : new QueryTracer(vertx.tracer(), (SqlConnectOptions)baseConnectOptions);
        VertxMetrics vertxMetrics = vertx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(baseConnectOptions.getSocketAddress(), "sql", baseConnectOptions.getMetricsName()) : null;
        PoolImpl pool = new PoolImpl(vertx, (Driver)this, tracer, metrics, 1, options, null, null, closeFuture);
        List lst = databases.stream().map(o -> this.createConnectionFactory((Vertx)vertx, (SqlConnectOptions)o)).collect(Collectors.toList());
        ConnectionFactory factory = ConnectionFactory.roundRobinSelector(lst);
        pool.connectionProvider(arg_0 -> ((ConnectionFactory)factory).connect(arg_0));
        pool.init();
        closeFuture.add((Closeable)factory);
        return pool;
    }

    public MSSQLConnectOptions parseConnectionUri(String uri) {
        JsonObject conf = MSSQLConnectionUriParser.parse(uri, false);
        return conf == null ? null : new MSSQLConnectOptions(conf);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof MSSQLConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    public ConnectionFactory createConnectionFactory(Vertx vertx, SqlConnectOptions database) {
        return new MSSQLConnectionFactory((VertxInternal)vertx, MSSQLConnectOptions.wrap(database));
    }

    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append('@').append('P').append(1 + index);
        return index;
    }

    public SqlConnectionInternal wrapConnection(ContextInternal context, ConnectionFactory factory, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        return new MSSQLConnectionImpl(context, factory, conn, tracer, metrics);
    }
}

