/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.impl.MSSQLConnectionImpl;
import io.vertx.mssqlclient.impl.MSSQLSocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;

public class MSSQLConnectionFactory
extends ConnectionFactoryBase {
    private final int desiredPacketSize;
    private final boolean clientConfigSsl;

    public MSSQLConnectionFactory(VertxInternal vertx, MSSQLConnectOptions options) {
        super(vertx, (SqlConnectOptions)options);
        this.desiredPacketSize = options.getPacketSize();
        this.clientConfigSsl = options.isSsl();
    }

    protected void initializeConfiguration(SqlConnectOptions options) {
    }

    protected void configureNetClientOptions(NetClientOptions netClientOptions) {
        netClientOptions.setSsl(false);
    }

    protected Future<Connection> doConnectInternal(SocketAddress server, String username, String password, String database, EventLoopContext context) {
        return this.connectOrRedirect(server, username, password, database, context, 0);
    }

    private Future<Connection> connectOrRedirect(SocketAddress server, String username, String password, String database, EventLoopContext context, int redirections) {
        if (redirections > 1) {
            return context.failedFuture("The client can be redirected only once");
        }
        return this.netClient.connect(server).map(so -> this.createSocketConnection((NetSocket)so, context)).compose(conn -> conn.sendPreLoginMessage(this.clientConfigSsl).compose(encryptionLevel -> this.login((MSSQLSocketConnection)((Object)conn), username, password, database, (Byte)encryptionLevel, context))).compose(connBase -> {
            MSSQLSocketConnection conn = (MSSQLSocketConnection)((Object)connBase);
            SocketAddress alternateServer = conn.getAlternateServer();
            if (alternateServer == null) {
                return context.succeededFuture((Object)conn);
            }
            PromiseInternal closePromise = context.promise();
            conn.close(null, (Promise)closePromise);
            return closePromise.future().transform(v -> this.connectOrRedirect(alternateServer, username, password, database, context, redirections + 1));
        });
    }

    private MSSQLSocketConnection createSocketConnection(NetSocket so, EventLoopContext context) {
        MSSQLSocketConnection conn = new MSSQLSocketConnection((NetSocketInternal)so, this.desiredPacketSize, false, 0, sql -> true, 1, context);
        conn.init();
        return conn;
    }

    private Future<Connection> login(MSSQLSocketConnection conn, String username, String password, String database, Byte encryptionLevel, EventLoopContext context) {
        if (this.clientConfigSsl && encryptionLevel != 1 && encryptionLevel != 3) {
            PromiseInternal closePromise = context.promise();
            conn.close(null, (Promise)closePromise);
            return closePromise.future().transform(v -> context.failedFuture("The client is configured for encryption but the server does not support it"));
        }
        Future<Void> future = encryptionLevel != 2 ? conn.enableSsl(this.clientConfigSsl, encryptionLevel, (MSSQLConnectOptions)this.options) : context.succeededFuture();
        return future.compose(v -> conn.sendLoginMessage(username, password, database, this.properties));
    }

    public Future<SqlConnection> connect(Context context) {
        ContextInternal ctx = (ContextInternal)context;
        QueryTracer tracer = ctx.tracer() == null ? null : new QueryTracer(ctx.tracer(), this.options);
        PromiseInternal promise = ctx.promise();
        this.connect(MSSQLConnectionFactory.asEventLoopContext((ContextInternal)ctx)).map(conn -> {
            MSSQLConnectionImpl msConn = new MSSQLConnectionImpl(ctx, (ConnectionFactory)this, (Connection)conn, tracer, null);
            conn.init((Connection.Holder)msConn);
            return msConn;
        }).onComplete((Handler)promise);
        return promise.future();
    }
}

