/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.mssqlclient.MSSQLInfo;
import java.util.Base64;
import java.util.Map;

public class MSSQLInfoConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, MSSQLInfo obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "lineNumber": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setLineNumber(((Number)member.getValue()).intValue());
                    break;
                }
                case "message": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setMessage((String)member.getValue());
                    break;
                }
                case "number": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setNumber(((Number)member.getValue()).intValue());
                    break;
                }
                case "procedureName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setProcedureName((String)member.getValue());
                    break;
                }
                case "serverName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setServerName((String)member.getValue());
                    break;
                }
                case "severity": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setSeverity(((Number)member.getValue()).byteValue());
                    break;
                }
                case "state": {
                    if (!(member.getValue() instanceof Number)) break;
                    obj.setState(((Number)member.getValue()).byteValue());
                }
            }
        }
    }

    public static void toJson(MSSQLInfo obj, JsonObject json) {
        MSSQLInfoConverter.toJson(obj, json.getMap());
    }

    public static void toJson(MSSQLInfo obj, Map<String, Object> json) {
        json.put("lineNumber", obj.getLineNumber());
        if (obj.getMessage() != null) {
            json.put("message", obj.getMessage());
        }
        json.put("number", obj.getNumber());
        if (obj.getProcedureName() != null) {
            json.put("procedureName", obj.getProcedureName());
        }
        if (obj.getServerName() != null) {
            json.put("serverName", obj.getServerName());
        }
        json.put("severity", obj.getSeverity());
        json.put("state", obj.getState());
    }
}

