/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.codec.CursorData;
import io.vertx.mssqlclient.impl.codec.DataType;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.sqlclient.impl.command.CloseCursorCommand;
import io.vertx.sqlclient.impl.command.CommandResponse;

public class CloseCursorCommandCodec
extends MSSQLCommandCodec<Void, CloseCursorCommand> {
    private final CursorData cursorData;
    private boolean cursorClosed;

    public CloseCursorCommandCodec(TdsMessageCodec tdsMessageCodec, CloseCursorCommand cmd) {
        super(tdsMessageCodec, cmd);
        this.cursorData = tdsMessageCodec.removeCursorData(cmd.id());
    }

    @Override
    void encode() {
        if (this.cursorData != null && this.cursorData.serverCursorId > 0) {
            this.sendCursorClose();
        } else {
            this.completionHandler.handle((Object)CommandResponse.success(null));
        }
    }

    private void sendCursorClose() {
        ByteBuf content = this.tdsMessageCodec.alloc().ioBuffer();
        this.tdsMessageCodec.encoder().encodeHeaders(content);
        content.writeShortLE(65535);
        content.writeShortLE(9);
        content.writeShortLE(0);
        DataType.INTN.encodeParam(content, null, false, this.cursorData.serverCursorId);
        this.tdsMessageCodec.encoder().writeTdsMessage((short)3, content);
    }

    @Override
    protected void handleDecodingComplete() {
        if (this.cursorClosed) {
            super.handleDecodingComplete();
        } else {
            this.cursorClosed = true;
            this.sendUnprepare();
        }
    }

    private void sendUnprepare() {
        ByteBuf content = this.tdsMessageCodec.alloc().ioBuffer();
        this.tdsMessageCodec.encoder().encodeHeaders(content);
        content.writeShortLE(65535);
        content.writeShortLE(15);
        content.writeShortLE(0);
        DataType.INTN.encodeParam(content, null, false, this.cursorData.preparedHandle);
        this.tdsMessageCodec.encoder().writeTdsMessage((short)3, content);
    }
}

