/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.MSSQLRowImpl;
import io.vertx.mssqlclient.impl.codec.ColumnData;
import io.vertx.mssqlclient.impl.codec.MSSQLRowDesc;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.RowDecoder;
import java.util.Objects;
import java.util.stream.Collector;

public class RowResultDecoder<C, R>
extends RowDecoder<C, R> {
    private static final int FETCH_MISSING = 2;
    private final MSSQLRowDesc desc;
    private Row decoded;

    public RowResultDecoder(Collector<Row, C, R> collector, MSSQLRowDesc desc) {
        super(collector);
        this.desc = desc;
    }

    public MSSQLRowDesc desc() {
        return this.desc;
    }

    public Row decodeRow(int len, ByteBuf in) {
        Row row = Objects.requireNonNull(this.decoded);
        this.decoded = null;
        return row;
    }

    public void handleRow(ByteBuf in) {
        this.decoded = this.decodeMssqlRow(in);
        if (this.decoded != null) {
            super.handleRow(-1, in);
        }
    }

    public void handleNbcRow(ByteBuf in) {
        this.decoded = this.decodeMssqlNbcRow(in);
        if (this.decoded != null) {
            super.handleRow(-1, in);
        }
    }

    private Row decodeMssqlRow(ByteBuf in) {
        MSSQLRowImpl row = new MSSQLRowImpl(this.desc);
        int len = this.desc.size();
        for (int c = 0; c < len; ++c) {
            ColumnData columnData = this.desc.get(c);
            row.addValue(columnData.dataType().decodeValue(in, columnData.typeInfo()));
        }
        return this.ifNotMissing(in, row);
    }

    private Row ifNotMissing(ByteBuf in, Row row) {
        Object result = this.desc.hasRowStat() && in.readIntLE() == 2 ? null : row;
        return result;
    }

    private Row decodeMssqlNbcRow(ByteBuf in) {
        MSSQLRowImpl row = new MSSQLRowImpl(this.desc);
        int len = this.desc.size();
        int nullBitmapByteCount = (len - 1 >> 3) + 1;
        int nullBitMapStartIdx = in.readerIndex();
        in.skipBytes(nullBitmapByteCount);
        for (int c = 0; c < len; ++c) {
            int bytePos = c >> 3;
            int bitPos = c & 7;
            byte mask = (byte)(1 << bitPos);
            byte nullByte = in.getByte(nullBitMapStartIdx + bytePos);
            Object decoded = null;
            if ((nullByte & mask) == 0) {
                ColumnData columnData = this.desc.get(c);
                decoded = columnData.dataType().decodeValue(in, columnData.typeInfo());
            }
            row.addValue(decoded);
        }
        return this.ifNotMissing(in, row);
    }
}

