/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.codec.ExtendedQueryCommandBaseCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.util.List;

class ExtendedBatchQueryCommandCodec<T>
extends ExtendedQueryCommandBaseCodec<T> {
    private final List<TupleInternal> paramsList;
    private int paramsIdx;
    private int messageDecoded;

    ExtendedBatchQueryCommandCodec(TdsMessageCodec tdsMessageCodec, ExtendedQueryCommand<T> cmd) {
        super(tdsMessageCodec, cmd);
        this.paramsList = cmd.paramsList();
    }

    @Override
    void encode() {
        if (this.paramsList.isEmpty()) {
            this.tdsMessageCodec.decoder().fireCommandResponse(CommandResponse.failure((String)"Can not execute batch query with 0 sets of batch parameters."));
            return;
        }
        super.encode();
    }

    @Override
    protected void handleDecodingComplete() {
        if (this.paramsList.size() == 1 || ++this.messageDecoded == 2) {
            this.complete();
        } else {
            this.sendExecRequest();
        }
    }

    @Override
    protected TupleInternal prepexecRequestParams() {
        this.paramsIdx = 1;
        return this.paramsList.get(0);
    }

    @Override
    protected void writeRpcRequestBatch(ByteBuf packet) {
        int initial = this.paramsIdx;
        while (this.paramsIdx < this.paramsList.size()) {
            if (initial != this.paramsIdx) {
                packet.writeByte(255);
            }
            super.writeRpcRequestBatch(packet);
            ++this.paramsIdx;
        }
    }

    @Override
    protected TupleInternal execRequestParams() {
        return this.paramsList.get(this.paramsIdx);
    }
}

