/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.sqlclient.impl.RowBase;
import io.vertx.sqlclient.impl.RowDesc;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.UUID;

public class MSSQLRowImpl
extends RowBase {
    private final RowDesc rowDesc;

    public MSSQLRowImpl(RowDesc rowDesc) {
        super(rowDesc.columnNames().size());
        this.rowDesc = rowDesc;
    }

    public String getColumnName(int pos) {
        List columnNames = this.rowDesc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String column) {
        if (column == null) {
            throw new IllegalArgumentException("Column name can not be null");
        }
        return this.rowDesc.columnNames().indexOf(column);
    }

    public <T> T get(Class<T> type, int position) {
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(position));
        }
        if (type == Byte.class) {
            return type.cast(this.getByte(position));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(position));
        }
        if (type == Integer.class) {
            return type.cast(this.getInteger(position));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(position));
        }
        if (type == Float.class) {
            return type.cast(this.getFloat(position));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(position));
        }
        if (type == BigDecimal.class) {
            return type.cast(this.getBigDecimal(position));
        }
        if (type == String.class) {
            return type.cast(this.getString(position));
        }
        if (type == LocalDate.class) {
            return type.cast(this.getLocalDate(position));
        }
        if (type == LocalTime.class) {
            return type.cast(this.getLocalTime(position));
        }
        if (type == LocalDateTime.class) {
            return type.cast(this.getLocalDateTime(position));
        }
        if (type == OffsetDateTime.class) {
            return type.cast(this.getOffsetDateTime(position));
        }
        if (type == Buffer.class) {
            return type.cast(this.getBuffer(position));
        }
        if (type == UUID.class) {
            return type.cast(this.getValue(position));
        }
        if (type == Object.class) {
            return type.cast(this.getValue(position));
        }
        if (type.isEnum()) {
            return type.cast(this.getEnum(type, position));
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public Temporal getTemporal(int pos) {
        throw new UnsupportedOperationException();
    }

    public UUID getUUID(int pos) {
        return this.get(UUID.class, pos);
    }

    public LocalDateTime[] getArrayOfLocalDateTimes(int pos) {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime[] getArrayOfOffsetDateTimes(int pos) {
        throw new UnsupportedOperationException();
    }

    public Buffer[] getArrayOfBuffers(String column) {
        throw new UnsupportedOperationException();
    }

    public UUID[] getArrayOfUUIDs(String column) {
        throw new UnsupportedOperationException();
    }

    private Byte getByte(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Byte) {
            return (Byte)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        return null;
    }

    private Object getEnum(Class enumType, int position) {
        Object val = this.getValue(position);
        if (val instanceof String) {
            return Enum.valueOf(enumType, (String)val);
        }
        if (val instanceof Number) {
            T[] constants;
            int ordinal = ((Number)val).intValue();
            if (ordinal >= 0 && ordinal < (constants = enumType.getEnumConstants()).length) {
                return constants[ordinal];
            }
        } else if (val == null) {
            return null;
        }
        throw new ClassCastException();
    }
}

