/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.MSSQLRowDesc;
import io.vertx.mssqlclient.impl.codec.RowResultDecoder;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.command.QueryCommandBase;
import java.util.stream.Collector;

abstract class QueryCommandBaseCodec<T, C extends QueryCommandBase<T>>
extends MSSQLCommandCodec<Boolean, C> {
    protected int rowCount;
    protected RowResultDecoder<?, T> rowResultDecoder;

    QueryCommandBaseCodec(TdsMessageCodec tdsMessageCodec, C cmd) {
        super(tdsMessageCodec, cmd);
    }

    private static <A, T> T emptyResult(Collector<Row, A, T> collector) {
        return collector.finisher().apply(collector.supplier().get());
    }

    @Override
    protected void handleRowDesc(MSSQLRowDesc mssqlRowDesc) {
        this.rowResultDecoder = new RowResultDecoder(((QueryCommandBase)this.cmd).collector(), mssqlRowDesc);
    }

    @Override
    protected void handleRow(ByteBuf payload) {
        this.rowResultDecoder.nbc = false;
        this.rowResultDecoder.handleRow(-1, payload);
    }

    @Override
    protected void handleNbcRow(ByteBuf payload) {
        this.rowResultDecoder.nbc = true;
        this.rowResultDecoder.handleRow(-1, payload);
    }

    @Override
    protected void handleAffectedRows(long count) {
        this.rowCount = (int)Math.min(count, Integer.MAX_VALUE);
    }

    protected void handleResultSetDone() {
        int size;
        MSSQLRowDesc rowDesc;
        Object result;
        Throwable failure;
        this.result = false;
        if (this.rowResultDecoder != null) {
            failure = this.rowResultDecoder.complete();
            result = this.rowResultDecoder.result();
            rowDesc = this.rowResultDecoder.desc();
            size = this.rowResultDecoder.size();
            this.rowResultDecoder.reset();
        } else {
            result = QueryCommandBaseCodec.emptyResult(((QueryCommandBase)this.cmd).collector());
            failure = null;
            size = 0;
            rowDesc = null;
        }
        ((QueryCommandBase)this.cmd).resultHandler().handleResult(this.rowCount, size, (RowDesc)rowDesc, result, failure);
    }
}

