/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.vertx.mssqlclient.impl.codec.Encoding;

public enum WindowsLocale {
    ar_SA(1025, Encoding.CP1256),
    bg_BG(1026, Encoding.CP1251),
    ca_ES(1027, Encoding.CP1252),
    zh_TW(1028, Encoding.CP950),
    cs_CZ(1029, Encoding.CP1250),
    da_DK(1030, Encoding.CP1252),
    de_DE(1031, Encoding.CP1252),
    el_GR(1032, Encoding.CP1253),
    en_US(1033, Encoding.CP1252),
    es_ES_tradnl(1034, Encoding.CP1252),
    fi_FI(1035, Encoding.CP1252),
    fr_FR(1036, Encoding.CP1252),
    he_IL(1037, Encoding.CP1255),
    hu_HU(1038, Encoding.CP1250),
    is_IS(1039, Encoding.CP1252),
    it_IT(1040, Encoding.CP1252),
    ja_JP(1041, Encoding.CP932),
    ko_KR(1042, Encoding.CP949),
    nl_NL(1043, Encoding.CP1252),
    nb_NO(1044, Encoding.CP1252),
    pl_PL(1045, Encoding.CP1250),
    pt_BR(1046, Encoding.CP1252),
    rm_CH(1047, Encoding.CP1252),
    ro_RO(1048, Encoding.CP1250),
    ru_RU(1049, Encoding.CP1251),
    hr_HR(1050, Encoding.CP1250),
    sk_SK(1051, Encoding.CP1250),
    sq_AL(1052, Encoding.CP1250),
    sv_SE(1053, Encoding.CP1252),
    th_TH(1054, Encoding.CP874),
    tr_TR(1055, Encoding.CP1254),
    ur_PK(1056, Encoding.CP1256),
    id_ID(1057, Encoding.CP1252),
    uk_UA(1058, Encoding.CP1251),
    be_BY(1059, Encoding.CP1251),
    sl_SI(1060, Encoding.CP1250),
    et_EE(1061, Encoding.CP1257),
    lv_LV(1062, Encoding.CP1257),
    lt_LT(1063, Encoding.CP1257),
    tg_Cyrl_TJ(1064, Encoding.CP1251),
    fa_IR(1065, Encoding.CP1256),
    vi_VN(1066, Encoding.CP1258),
    hy_AM(1067, Encoding.CP1252),
    az_Latn_AZ(1068, Encoding.CP1254),
    eu_ES(1069, Encoding.CP1252),
    wen_DE(1070, Encoding.CP1252),
    mk_MK(1071, Encoding.CP1251),
    tn_ZA(1074, Encoding.CP1252),
    xh_ZA(1076, Encoding.CP1252),
    zu_ZA(1077, Encoding.CP1252),
    Af_ZA(1078, Encoding.CP1252),
    ka_GE(1079, Encoding.CP1252),
    fo_FO(1080, Encoding.CP1252),
    hi_IN(1081, Encoding.UNICODE),
    mt_MT(1082, Encoding.UNICODE),
    se_NO(1083, Encoding.CP1252),
    ms_MY(1086, Encoding.CP1252),
    kk_KZ(1087, Encoding.CP1251),
    ky_KG(1088, Encoding.CP1251),
    sw_KE(1089, Encoding.CP1252),
    tk_TM(1090, Encoding.CP1250),
    uz_Latn_UZ(1091, Encoding.CP1254),
    tt_RU(1092, Encoding.CP1251),
    bn_IN(1093, Encoding.UNICODE),
    pa_IN(1094, Encoding.UNICODE),
    gu_IN(1095, Encoding.UNICODE),
    or_IN(1096, Encoding.UNICODE),
    ta_IN(1097, Encoding.UNICODE),
    te_IN(1098, Encoding.UNICODE),
    kn_IN(1099, Encoding.UNICODE),
    ml_IN(1100, Encoding.UNICODE),
    as_IN(1101, Encoding.UNICODE),
    mr_IN(1102, Encoding.UNICODE),
    sa_IN(1103, Encoding.UNICODE),
    mn_MN(1104, Encoding.CP1251),
    bo_CN(1105, Encoding.UNICODE),
    cy_GB(1106, Encoding.CP1252),
    km_KH(1107, Encoding.UNICODE),
    lo_LA(1108, Encoding.UNICODE),
    gl_ES(1110, Encoding.CP1252),
    kok_IN(1111, Encoding.UNICODE),
    syr_SY(1114, Encoding.UNICODE),
    si_LK(1115, Encoding.UNICODE),
    iu_Cans_CA(1117, Encoding.CP1252),
    am_ET(1118, Encoding.CP1252),
    ne_NP(1121, Encoding.UNICODE),
    fy_NL(1122, Encoding.CP1252),
    ps_AF(1123, Encoding.UNICODE),
    fil_PH(1124, Encoding.CP1252),
    dv_MV(1125, Encoding.UNICODE),
    ha_Latn_NG(1128, Encoding.CP1252),
    yo_NG(1130, Encoding.CP1252),
    quz_BO(1131, Encoding.CP1252),
    nso_ZA(1132, Encoding.CP1252),
    ba_RU(1133, Encoding.CP1251),
    lb_LU(1134, Encoding.CP1252),
    kl_GL(1135, Encoding.CP1252),
    ig_NG(1136, Encoding.CP1252),
    ii_CN(1144, Encoding.CP1252),
    arn_CL(1146, Encoding.CP1252),
    moh_CA(1148, Encoding.CP1252),
    br_FR(1150, Encoding.CP1252),
    ug_CN(1152, Encoding.CP1256),
    mi_NZ(1153, Encoding.UNICODE),
    oc_FR(1154, Encoding.CP1252),
    co_FR(1155, Encoding.CP1252),
    gsw_FR(1156, Encoding.CP1252),
    sah_RU(1157, Encoding.CP1251),
    qut_GT(1158, Encoding.CP1252),
    rw_RW(1159, Encoding.CP1252),
    wo_SN(1160, Encoding.CP1252),
    prs_AF(1164, Encoding.CP1256),
    ar_IQ(2049, Encoding.CP1256),
    zh_CN(2052, Encoding.CP936),
    de_CH(2055, Encoding.CP1252),
    en_GB(2057, Encoding.CP1252),
    es_MX(2058, Encoding.CP1252),
    fr_BE(2060, Encoding.CP1252),
    it_CH(2064, Encoding.CP1252),
    nl_BE(2067, Encoding.CP1252),
    nn_NO(2068, Encoding.CP1252),
    pt_PT(2070, Encoding.CP1252),
    sr_Latn_CS(2074, Encoding.CP1250),
    sv_FI(2077, Encoding.CP1252),
    Lithuanian_Classic(2087, Encoding.CP1257),
    az_Cyrl_AZ(2092, Encoding.CP1251),
    dsb_DE(2094, Encoding.CP1252),
    se_SE(2107, Encoding.CP1252),
    ga_IE(2108, Encoding.CP1252),
    ms_BN(2110, Encoding.CP1252),
    uz_Cyrl_UZ(2115, Encoding.CP1251),
    bn_BD(2117, Encoding.UNICODE),
    mn_Mong_CN(2128, Encoding.CP1251),
    iu_Latn_CA(2141, Encoding.CP1252),
    tzm_Latn_DZ(2143, Encoding.CP1252),
    quz_EC(2155, Encoding.CP1252),
    ar_EG(3073, Encoding.CP1256),
    zh_HK(3076, Encoding.CP950),
    de_AT(3079, Encoding.CP1252),
    en_AU(3081, Encoding.CP1252),
    es_ES(3082, Encoding.CP1252),
    fr_CA(3084, Encoding.CP1252),
    sr_Cyrl_CS(3098, Encoding.CP1251),
    se_FI(3131, Encoding.CP1252),
    quz_PE(3179, Encoding.CP1252),
    ar_LY(4097, Encoding.CP1256),
    zh_SG(4100, Encoding.CP936),
    de_LU(4103, Encoding.CP1252),
    en_CA(4105, Encoding.CP1252),
    es_GT(4106, Encoding.CP1252),
    fr_CH(4108, Encoding.CP1252),
    hr_BA(4122, Encoding.CP1250),
    smj_NO(4155, Encoding.CP1252),
    ar_DZ(5121, Encoding.CP1256),
    zh_MO(5124, Encoding.CP950),
    de_LI(5127, Encoding.CP1252),
    en_NZ(5129, Encoding.CP1252),
    es_CR(5130, Encoding.CP1252),
    fr_LU(5132, Encoding.CP1252),
    bs_Latn_BA(5146, Encoding.CP1250),
    smj_SE(5179, Encoding.CP1252),
    ar_MA(6145, Encoding.CP1256),
    en_IE(6153, Encoding.CP1252),
    es_PA(6154, Encoding.CP1252),
    fr_MC(6156, Encoding.CP1252),
    sr_Latn_BA(6170, Encoding.CP1250),
    sma_NO(6203, Encoding.CP1252),
    ar_TN(7169, Encoding.CP1256),
    en_ZA(7177, Encoding.CP1252),
    es_DO(7178, Encoding.CP1252),
    sr_Cyrl_BA(7194, Encoding.CP1251),
    sma_SB(7227, Encoding.CP1252),
    ar_OM(8193, Encoding.CP1256),
    en_JM(8201, Encoding.CP1252),
    es_VE(8202, Encoding.CP1252),
    bs_Cyrl_BA(8218, Encoding.CP1251),
    sms_FI(8251, Encoding.CP1252),
    ar_YE(9217, Encoding.CP1256),
    en_CB(9225, Encoding.CP1252),
    es_CO(9226, Encoding.CP1252),
    smn_FI(9275, Encoding.CP1252),
    ar_SY(10241, Encoding.CP1256),
    en_BZ(10249, Encoding.CP1252),
    es_PE(10250, Encoding.CP1252),
    ar_JO(11265, Encoding.CP1256),
    en_TT(11273, Encoding.CP1252),
    es_AR(11274, Encoding.CP1252),
    ar_LB(12289, Encoding.CP1256),
    en_ZW(12297, Encoding.CP1252),
    es_EC(12298, Encoding.CP1252),
    ar_KW(13313, Encoding.CP1256),
    en_PH(13321, Encoding.CP1252),
    es_CL(13322, Encoding.CP1252),
    ar_AE(14337, Encoding.CP1256),
    es_UY(14346, Encoding.CP1252),
    ar_BH(15361, Encoding.CP1256),
    es_PY(15370, Encoding.CP1252),
    ar_QA(16385, Encoding.CP1256),
    en_IN(16393, Encoding.CP1252),
    es_BO(16394, Encoding.CP1252),
    en_MY(17417, Encoding.CP1252),
    es_SV(17418, Encoding.CP1252),
    en_SG(18441, Encoding.CP1252),
    es_HN(18442, Encoding.CP1252),
    es_NI(19466, Encoding.CP1252),
    es_PR(20490, Encoding.CP1252),
    es_US(21514, Encoding.CP1252);

    private final int langId;
    public final Encoding encoding;
    private static final IntObjectMap<WindowsLocale> windowsLocalesByLangId;

    private WindowsLocale(int langId, Encoding encoding) {
        this.langId = langId;
        this.encoding = encoding;
    }

    public static WindowsLocale forLangId(int langId) {
        WindowsLocale windowsLocale = (WindowsLocale)((Object)windowsLocalesByLangId.get(langId));
        if (windowsLocale == null) {
            throw new IllegalArgumentException("Unknown Windows locale: " + Integer.toHexString(langId));
        }
        return windowsLocale;
    }

    static {
        WindowsLocale[] values = WindowsLocale.values();
        windowsLocalesByLangId = new IntObjectHashMap(values.length);
        for (WindowsLocale windowsLocale : values) {
            windowsLocalesByLangId.put(windowsLocale.langId, (Object)windowsLocale);
        }
    }
}

