/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.vertx.mssqlclient.impl.codec.CursorData;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessageDecoder;
import io.vertx.mssqlclient.impl.codec.TdsMessageEncoder;
import io.vertx.sqlclient.ClosedConnectionException;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TdsMessageCodec
extends CombinedChannelDuplexHandler<TdsMessageDecoder, TdsMessageEncoder> {
    private final ArrayDeque<MSSQLCommandCodec<?, ?>> inflight = new ArrayDeque();
    private final TdsMessageEncoder encoder;
    private final TdsMessageDecoder decoder = new TdsMessageDecoder(this);
    private ChannelHandlerContext chctx;
    private ByteBufAllocator alloc;
    private long transactionDescriptor;
    private Map<String, CursorData> cursorDataMap;
    private Throwable failure;

    public TdsMessageCodec(int packetSize) {
        this.encoder = new TdsMessageEncoder(this, packetSize);
        this.init((ChannelInboundHandler)this.decoder, (ChannelOutboundHandler)this.encoder);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.chctx = ctx;
        this.alloc = this.chctx.alloc();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.fail(cause);
        super.exceptionCaught(ctx, cause);
    }

    private void fail(Throwable cause) {
        if (this.failure == null) {
            this.failure = cause;
            Iterator<MSSQLCommandCodec<?, ?>> it = this.inflight.iterator();
            while (it.hasNext()) {
                MSSQLCommandCodec<?, ?> codec = it.next();
                it.remove();
                this.fail(codec, cause);
            }
        }
    }

    private void fail(MSSQLCommandCodec<?, ?> codec, Throwable cause) {
        CommandResponse failure = CommandResponse.failure((Throwable)cause);
        failure.cmd = codec.cmd;
        this.chctx.fireChannelRead((Object)failure);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.fail((Throwable)ClosedConnectionException.INSTANCE);
        super.channelInactive(ctx);
    }

    TdsMessageEncoder encoder() {
        return this.encoder;
    }

    TdsMessageDecoder decoder() {
        return this.decoder;
    }

    ChannelHandlerContext chctx() {
        return this.chctx;
    }

    ByteBufAllocator alloc() {
        return this.alloc;
    }

    long transactionDescriptor() {
        return this.transactionDescriptor;
    }

    void setTransactionDescriptor(long transactionDescriptor) {
        this.transactionDescriptor = transactionDescriptor;
    }

    MSSQLCommandCodec<?, ?> peek() {
        return this.inflight.peek();
    }

    MSSQLCommandCodec<?, ?> poll() {
        return this.inflight.poll();
    }

    boolean add(MSSQLCommandCodec<?, ?> codec) {
        if (this.failure == null) {
            this.inflight.add(codec);
            return true;
        }
        this.fail(codec, this.failure);
        return false;
    }

    CursorData getOrCreateCursorData(String cursorId) {
        CursorData cd;
        if (this.cursorDataMap == null) {
            this.cursorDataMap = new HashMap<String, CursorData>();
        }
        if ((cd = this.cursorDataMap.get(cursorId)) == null) {
            cd = new CursorData();
            this.cursorDataMap.put(cursorId, cd);
        }
        return cd;
    }

    CursorData removeCursorData(String cursorId) {
        if (this.cursorDataMap == null) {
            return null;
        }
        CursorData cd = this.cursorDataMap.remove(cursorId);
        if (this.cursorDataMap.isEmpty()) {
            this.cursorDataMap = null;
        }
        return cd;
    }
}

