/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;

public class TdsSslHandshakeCodec
extends CombinedChannelDuplexHandler<ChannelInboundHandler, ChannelOutboundHandler> {
    public TdsSslHandshakeCodec() {
        LengthFieldBasedFrameDecoder decoder = new LengthFieldBasedFrameDecoder(Short.MAX_VALUE, 2, 2, -4, 8);
        this.init((ChannelInboundHandler)decoder, (ChannelOutboundHandler)new Encoder());
    }

    private static class Encoder
    extends ChannelOutboundHandlerAdapter {
        private CompositeByteBuf accumulator;

        private Encoder() {
        }

        public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
            if (this.accumulator != null) {
                this.accumulator.release();
            }
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (msg instanceof ByteBuf) {
                this.accumulate(ctx.alloc(), (ByteBuf)msg);
                promise.setSuccess();
            } else {
                super.write(ctx, msg, promise);
            }
        }

        private void accumulate(ByteBufAllocator alloc, ByteBuf byteBuf) {
            if (this.accumulator == null) {
                this.accumulator = alloc.compositeBuffer();
            }
            this.accumulator.addComponent(true, byteBuf);
        }

        public void flush(ChannelHandlerContext ctx) throws Exception {
            if (this.accumulator != null) {
                ByteBuf header = ctx.alloc().ioBuffer(8);
                header.writeByte(18);
                header.writeByte(1);
                header.writeShort(8 + this.accumulator.writerIndex());
                header.writeZero(4);
                ctx.write((Object)header, ctx.voidPromise());
                ctx.writeAndFlush((Object)this.accumulator, ctx.voidPromise());
                this.accumulator = null;
            } else {
                ctx.flush();
            }
        }
    }
}

