/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.TdsMessage;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.mssqlclient.impl.codec.TdsPacket;
import io.vertx.sqlclient.impl.command.CommandResponse;

public class TdsMessageDecoder
extends ChannelInboundHandlerAdapter {
    private final TdsMessageCodec tdsMessageCodec;
    private ChannelHandlerContext chctx;
    private ByteBufAllocator alloc;
    private TdsMessage message;

    public TdsMessageDecoder(TdsMessageCodec tdsMessageCodec) {
        this.tdsMessageCodec = tdsMessageCodec;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.chctx = ctx;
        this.alloc = ctx.alloc();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        TdsPacket tdsPacket = (TdsPacket)((Object)msg);
        if (this.message == null) {
            this.message = TdsMessage.createForDecoding(this.alloc, tdsPacket);
        } else {
            this.message.aggregate(tdsPacket);
        }
        if (tdsPacket.status() == 1) {
            this.decodeMessage();
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.releaseMessage();
    }

    void fireCommandResponse(CommandResponse<?> commandResponse) {
        MSSQLCommandCodec<?, ?> c = this.tdsMessageCodec.poll();
        commandResponse.cmd = c.cmd;
        this.chctx.fireChannelRead(commandResponse);
    }

    private void releaseMessage() {
        if (this.message != null) {
            this.message.release();
            this.message = null;
        }
    }

    private void decodeMessage() {
        try {
            MSSQLCommandCodec<?, ?> commandCodec = this.tdsMessageCodec.peek();
            if (commandCodec == null) {
                throw new IllegalStateException("No command codec for message of type [" + this.message.type() + "]");
            }
            commandCodec.decode(this.message.content());
        }
        finally {
            this.releaseMessage();
        }
    }
}

