/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.spi;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.impl.MSSQLConnectionFactory;
import io.vertx.mssqlclient.impl.MSSQLConnectionImpl;
import io.vertx.mssqlclient.impl.MSSQLConnectionUriParser;
import io.vertx.mssqlclient.impl.MSSQLPoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PoolImpl;
import io.vertx.sqlclient.impl.SingletonSupplier;
import io.vertx.sqlclient.impl.SqlConnectionInternal;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;
import java.util.function.Supplier;

public class MSSQLDriver
implements Driver {
    private static final String SHARED_CLIENT_KEY = "__vertx.shared.mssqlclient";
    public static final MSSQLDriver INSTANCE = new MSSQLDriver();

    public Pool newPool(Vertx vertx, Supplier<? extends Future<? extends SqlConnectOptions>> databases, PoolOptions options, CloseFuture closeFuture) {
        VertxInternal vx = (VertxInternal)vertx;
        PoolImpl pool = options.isShared() ? (PoolImpl)vx.createSharedClient(SHARED_CLIENT_KEY, options.getName(), closeFuture, cf -> this.newPoolImpl(vx, databases, options, (CloseFuture)cf)) : this.newPoolImpl(vx, databases, options, closeFuture);
        return new MSSQLPoolImpl(vx, closeFuture, (Pool)pool);
    }

    private PoolImpl newPoolImpl(VertxInternal vertx, Supplier<? extends Future<? extends SqlConnectOptions>> databases, PoolOptions options, CloseFuture closeFuture) {
        PoolImpl pool = new PoolImpl(vertx, (Driver)this, false, options, null, null, closeFuture);
        ConnectionFactory factory = this.createConnectionFactory((Vertx)vertx, databases);
        pool.connectionProvider(context -> factory.connect(context, (Future)databases.get()));
        pool.init();
        closeFuture.add((Closeable)factory);
        return pool;
    }

    public MSSQLConnectOptions parseConnectionUri(String uri) {
        JsonObject conf = MSSQLConnectionUriParser.parse(uri, false);
        return conf == null ? null : new MSSQLConnectOptions(conf);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof MSSQLConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    public ConnectionFactory createConnectionFactory(Vertx vertx, SqlConnectOptions database) {
        return new MSSQLConnectionFactory((VertxInternal)vertx, SingletonSupplier.wrap((Object)database));
    }

    public ConnectionFactory createConnectionFactory(Vertx vertx, Supplier<? extends Future<? extends SqlConnectOptions>> database) {
        return new MSSQLConnectionFactory((VertxInternal)vertx, database);
    }

    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append('@').append('P').append(1 + index);
        return index;
    }

    public SqlConnectionInternal wrapConnection(ContextInternal context, ConnectionFactory factory, Connection conn) {
        return new MSSQLConnectionImpl(context, factory, conn);
    }
}

