/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ClientSSLOptions;
import io.vertx.mssqlclient.MSSQLConnectOptionsConverter;
import io.vertx.mssqlclient.impl.MSSQLConnectionUriParser;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

@DataObject
@JsonGen(publicConverter=false)
public class MSSQLConnectOptions
extends SqlConnectOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 1433;
    public static final String DEFAULT_USER = "sa";
    public static final String DEFAULT_PASSWORD = "";
    public static final String DEFAULT_DATABASE = "";
    public static final String DEFAULT_APP_NAME = "vertx-mssql-client";
    public static final String DEFAULT_CLIENT_INTERFACE_NAME = "Vert.x";
    public static final Map<String, String> DEFAULT_PROPERTIES;
    public static final int MIN_PACKET_SIZE = 512;
    public static final int MAX_PACKET_SIZE = Short.MAX_VALUE;
    public static final int DEFAULT_PACKET_SIZE = 4096;
    public static final boolean DEFAULT_SSL = false;
    private boolean ssl;
    private int packetSize;

    public static MSSQLConnectOptions wrap(SqlConnectOptions options) {
        if (options instanceof MSSQLConnectOptions) {
            return (MSSQLConnectOptions)options;
        }
        return new MSSQLConnectOptions(options);
    }

    public static MSSQLConnectOptions fromUri(String connectionUri) throws IllegalArgumentException {
        JsonObject parsedConfiguration = MSSQLConnectionUriParser.parse(connectionUri);
        return new MSSQLConnectOptions(parsedConfiguration);
    }

    public MSSQLConnectOptions() {
    }

    public MSSQLConnectOptions(JsonObject json) {
        super(json);
        MSSQLConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public MSSQLConnectOptions(SqlConnectOptions other) {
        super(other);
        if (other instanceof MSSQLConnectOptions) {
            MSSQLConnectOptions opts = (MSSQLConnectOptions)other;
            this.copyFields(opts);
        }
    }

    public MSSQLConnectOptions(MSSQLConnectOptions other) {
        super((SqlConnectOptions)other);
        this.copyFields(other);
    }

    private void copyFields(MSSQLConnectOptions other) {
        this.packetSize = other.packetSize;
        this.ssl = other.ssl;
    }

    public MSSQLConnectOptions setHost(String host) {
        return (MSSQLConnectOptions)super.setHost(host);
    }

    public MSSQLConnectOptions setPort(int port) {
        return (MSSQLConnectOptions)super.setPort(port);
    }

    public MSSQLConnectOptions setUser(String user) {
        return (MSSQLConnectOptions)super.setUser(user);
    }

    public MSSQLConnectOptions setPassword(String password) {
        return (MSSQLConnectOptions)super.setPassword(password);
    }

    public MSSQLConnectOptions setDatabase(String database) {
        return (MSSQLConnectOptions)super.setDatabase(database);
    }

    public MSSQLConnectOptions setProperties(Map<String, String> properties) {
        return (MSSQLConnectOptions)super.setProperties(properties);
    }

    public MSSQLConnectOptions addProperty(String key, String value) {
        return (MSSQLConnectOptions)super.addProperty(key, value);
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public MSSQLConnectOptions setPacketSize(int packetSize) {
        if (packetSize < 512 || packetSize > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Packet size: " + packetSize);
        }
        this.packetSize = packetSize;
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public MSSQLConnectOptions setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public MSSQLConnectOptions setReconnectAttempts(int attempts) {
        return (MSSQLConnectOptions)super.setReconnectAttempts(attempts);
    }

    public MSSQLConnectOptions setReconnectInterval(long interval) {
        return (MSSQLConnectOptions)super.setReconnectInterval(interval);
    }

    public MSSQLConnectOptions setCachePreparedStatements(boolean cachePreparedStatements) {
        return (MSSQLConnectOptions)super.setCachePreparedStatements(cachePreparedStatements);
    }

    public MSSQLConnectOptions setPreparedStatementCacheMaxSize(int preparedStatementCacheMaxSize) {
        return (MSSQLConnectOptions)super.setPreparedStatementCacheMaxSize(preparedStatementCacheMaxSize);
    }

    @GenIgnore
    public MSSQLConnectOptions setPreparedStatementCacheSqlFilter(Predicate<String> predicate) {
        return (MSSQLConnectOptions)super.setPreparedStatementCacheSqlFilter(predicate);
    }

    public MSSQLConnectOptions setPreparedStatementCacheSqlLimit(int preparedStatementCacheSqlLimit) {
        return (MSSQLConnectOptions)super.setPreparedStatementCacheSqlLimit(preparedStatementCacheSqlLimit);
    }

    public MSSQLConnectOptions setSslOptions(ClientSSLOptions sslOptions) {
        return (MSSQLConnectOptions)super.setSslOptions(sslOptions);
    }

    protected void init() {
        this.setHost(DEFAULT_HOST);
        this.setPort(1433);
        this.setUser(DEFAULT_USER);
        this.setPassword("");
        this.setDatabase("");
        this.setMetricsName("");
        this.setProperties(new HashMap<String, String>(DEFAULT_PROPERTIES));
        this.packetSize = 4096;
        this.ssl = false;
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        MSSQLConnectOptionsConverter.toJson(this, json);
        return json;
    }

    public MSSQLConnectOptions merge(JsonObject other) {
        JsonObject json = this.toJson();
        json.mergeIn(other);
        return new MSSQLConnectOptions(json);
    }

    static {
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("appName", DEFAULT_APP_NAME);
        defaultProperties.put("clientInterfaceName", DEFAULT_CLIENT_INTERFACE_NAME);
        DEFAULT_PROPERTIES = defaultProperties;
    }
}

