/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mssqlclient.impl.codec.DataType;
import io.vertx.mssqlclient.impl.codec.MSSQLCommandCodec;
import io.vertx.mssqlclient.impl.codec.MSSQLPreparedStatement;
import io.vertx.mssqlclient.impl.codec.TdsMessageCodec;
import io.vertx.sqlclient.internal.command.CloseStatementCommand;
import io.vertx.sqlclient.internal.command.CommandResponse;

class CloseStatementCommandCodec
extends MSSQLCommandCodec<Void, CloseStatementCommand> {
    CloseStatementCommandCodec(TdsMessageCodec tdsMessageCodec, CloseStatementCommand cmd) {
        super(tdsMessageCodec, cmd);
    }

    @Override
    void encode() {
        MSSQLPreparedStatement ps = (MSSQLPreparedStatement)((CloseStatementCommand)this.cmd).statement();
        if (ps.handle > 0) {
            this.sendUnprepareRequest();
        } else {
            this.tdsMessageCodec.decoder().fireCommandResponse(CommandResponse.success(null));
        }
    }

    private void sendUnprepareRequest() {
        ByteBuf content = this.tdsMessageCodec.alloc().ioBuffer();
        this.tdsMessageCodec.encoder().encodeHeaders(content);
        content.writeShortLE(65535);
        content.writeShortLE(15);
        content.writeShortLE(0);
        DataType.INTN.encodeParam(content, null, false, ((MSSQLPreparedStatement)((CloseStatementCommand)this.cmd).statement()).handle);
        this.tdsMessageCodec.encoder().writeTdsMessage((short)3, content);
    }
}

