/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl;

import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.internal.tls.SslContextManager;
import io.vertx.core.net.HostAndPort;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.impl.MSSQLConnectionImpl;
import io.vertx.mssqlclient.impl.MSSQLSocketConnection;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.Map;

public class MSSQLConnectionFactory
extends ConnectionFactoryBase<MSSQLConnectOptions> {
    private final SslContextManager sslContextManager;

    public MSSQLConnectionFactory(VertxInternal vertx) {
        super(vertx);
        this.sslContextManager = new SslContextManager(SslContextManager.resolveEngineOptions((SSLEngineOptions)this.tcpOptions.getSslEngineOptions(), (boolean)this.tcpOptions.isUseAlpn()));
    }

    protected Future<Connection> doConnectInternal(MSSQLConnectOptions options, ContextInternal context) {
        return this.connectOrRedirect(options, context, 0);
    }

    private Future<Connection> connectOrRedirect(MSSQLConnectOptions options, ContextInternal context, int redirections) {
        if (redirections > 1) {
            return context.failedFuture("The client can be redirected only once");
        }
        SocketAddress server = options.getSocketAddress();
        boolean clientSslConfig = options.isSsl();
        return this.client.connect(server).map(so -> this.createSocketConnection((NetSocket)so, options, context)).compose(conn -> conn.sendPreLoginMessage(clientSslConfig).compose(encryptionLevel -> this.login((MSSQLSocketConnection)((Object)conn), options, (Byte)encryptionLevel, context))).compose(connBase -> {
            MSSQLSocketConnection conn = (MSSQLSocketConnection)((Object)connBase);
            HostAndPort alternateServer = conn.getAlternateServer();
            if (alternateServer == null) {
                return context.succeededFuture((Object)conn);
            }
            PromiseInternal closePromise = context.promise();
            conn.close(null, (Completable)closePromise);
            return closePromise.future().transform(v -> {
                MSSQLConnectOptions connectOptions = new MSSQLConnectOptions(options).setHost(alternateServer.host()).setPort(alternateServer.port());
                return this.connectOrRedirect(connectOptions, context, redirections + 1);
            });
        });
    }

    private MSSQLSocketConnection createSocketConnection(NetSocket so, MSSQLConnectOptions options, ContextInternal context) {
        VertxMetrics vertxMetrics = this.vertx.metrics();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(options.getSocketAddress(), "sql", options.getMetricsName()) : null;
        MSSQLSocketConnection conn = new MSSQLSocketConnection((NetSocketInternal)so, this.sslContextManager, metrics, options, false, 0, sql -> true, 1, context);
        conn.init();
        return conn;
    }

    private Future<Connection> login(MSSQLSocketConnection conn, MSSQLConnectOptions options, Byte encryptionLevel, ContextInternal context) {
        boolean clientSslConfig = options.isSsl();
        if (clientSslConfig && encryptionLevel != 1 && encryptionLevel != 3) {
            PromiseInternal closePromise = context.promise();
            conn.close(null, (Completable)closePromise);
            return closePromise.future().transform(v -> context.failedFuture("The client is configured for encryption but the server does not support it"));
        }
        Future<Void> future = encryptionLevel != 2 ? conn.enableSsl(clientSslConfig, encryptionLevel, options) : context.succeededFuture();
        String username = options.getUser();
        String password = options.getPassword();
        String database = options.getDatabase();
        Map properties = options.getProperties();
        return future.compose(v -> conn.sendLoginMessage(username, password, database, properties));
    }

    public Future<SqlConnection> connect(Context context, MSSQLConnectOptions options) {
        ContextInternal ctx = (ContextInternal)context;
        PromiseInternal promise = ctx.promise();
        this.connect(MSSQLConnectionFactory.asEventLoopContext((ContextInternal)ctx), options).map(conn -> {
            MSSQLConnectionImpl msConn = new MSSQLConnectionImpl(ctx, (ConnectionFactory)this, (Connection)conn);
            conn.init((Connection.Holder)msConn);
            return msConn;
        }).onComplete((Completable)promise);
        return promise.future();
    }
}

