/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.VertxException;
import io.vertx.mssqlclient.impl.codec.SortOrder;
import io.vertx.mssqlclient.impl.codec.WindowsLocale;
import java.nio.charset.Charset;

public enum Encoding {
    UNICODE("UTF-16LE"),
    UTF8("UTF-8"),
    CP437("Cp437"),
    CP850("Cp850"),
    CP874("MS874"),
    CP932("MS932"),
    CP936("MS936"),
    CP949("MS949"),
    CP950("MS950"),
    CP1250("Cp1250"),
    CP1251("Cp1251"),
    CP1252("Cp1252"),
    CP1253("Cp1253"),
    CP1254("Cp1254"),
    CP1255("Cp1255"),
    CP1256("Cp1256"),
    CP1257("Cp1257"),
    CP1258("Cp1258");

    public final String charsetName;
    public final Charset charset;
    private static final int UTF8_IN_TDSCOLLATION = 0x4000000;

    private Encoding(String charsetName) {
        this.charsetName = charsetName;
        this.charset = Charset.isSupported(charsetName) ? Charset.forName(charsetName) : null;
    }

    public static Charset readCharsetFrom(ByteBuf byteBuf) {
        int info = byteBuf.readIntLE();
        short sortId = byteBuf.readUnsignedByte();
        Encoding encoding = 0x4000000 == (info & 0x4000000) ? UTF8 : (sortId == 0 ? WindowsLocale.forLangId((int)(info & 0xFFFF)).encoding : SortOrder.forId((int)sortId).encoding);
        if (encoding.charset == null) {
            throw new VertxException("Unsupported encoding: " + String.valueOf((Object)encoding) + ". Verify if your JVM supports it.");
        }
        return encoding.charset;
    }

    public String toString() {
        return this.charsetName;
    }
}

