/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mssqlclient.spi;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.mssqlclient.MSSQLConnectOptions;
import io.vertx.mssqlclient.impl.MSSQLConnectionFactory;
import io.vertx.mssqlclient.impl.MSSQLConnectionImpl;
import io.vertx.mssqlclient.impl.MSSQLConnectionUriParser;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.SqlConnectionInternal;
import io.vertx.sqlclient.internal.pool.CloseablePool;
import io.vertx.sqlclient.internal.pool.PoolImpl;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;
import java.util.function.Supplier;

public class MSSQLDriver
implements Driver<MSSQLConnectOptions> {
    private static final String SHARED_CLIENT_KEY = "__vertx.shared.mssqlclient";
    public static final MSSQLDriver INSTANCE = new MSSQLDriver();

    public MSSQLConnectOptions downcast(SqlConnectOptions connectOptions) {
        return connectOptions instanceof MSSQLConnectOptions ? (MSSQLConnectOptions)connectOptions : new MSSQLConnectOptions(connectOptions);
    }

    public Pool newPool(Vertx vertx, Supplier<Future<MSSQLConnectOptions>> databases, PoolOptions options, NetClientOptions transportOptions, Handler<SqlConnection> connectHandler, CloseFuture closeFuture) {
        VertxInternal vx = (VertxInternal)vertx;
        PoolImpl pool = options.isShared() ? (PoolImpl)vx.createSharedResource(SHARED_CLIENT_KEY, options.getName(), closeFuture, cf -> this.newPoolImpl(vx, connectHandler, databases, options, transportOptions, (CloseFuture)cf)) : this.newPoolImpl(vx, connectHandler, databases, options, transportOptions, closeFuture);
        return new CloseablePool(vx, closeFuture, (Pool)pool);
    }

    private PoolImpl newPoolImpl(VertxInternal vertx, Handler<SqlConnection> connectHandler, Supplier<Future<MSSQLConnectOptions>> databases, PoolOptions poolOptions, NetClientOptions transportOptions, CloseFuture closeFuture) {
        ConnectionFactory<MSSQLConnectOptions> factory = this.createConnectionFactory((Vertx)vertx, transportOptions);
        PoolImpl pool = new PoolImpl(vertx, (Driver)this, false, poolOptions, null, null, context -> factory.connect(context, (Future)databases.get()), connectHandler, closeFuture);
        pool.init();
        closeFuture.add(factory);
        return pool;
    }

    public ConnectionFactory<MSSQLConnectOptions> createConnectionFactory(Vertx vertx, NetClientOptions transportOptions) {
        return new MSSQLConnectionFactory((VertxInternal)vertx);
    }

    public MSSQLConnectOptions parseConnectionUri(String uri) {
        JsonObject conf = MSSQLConnectionUriParser.parse(uri, false);
        return conf == null ? null : new MSSQLConnectOptions(conf);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof MSSQLConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append('@').append('P').append(1 + index);
        return index;
    }

    public SqlConnectionInternal wrapConnection(ContextInternal context, ConnectionFactory<MSSQLConnectOptions> factory, Connection conn) {
        return new MSSQLConnectionImpl(context, factory, conn);
    }
}

