/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLSetOption;
import io.vertx.mysqlclient.impl.MySQLConnectionImpl;
import io.vertx.sqlclient.PreparedQuery;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import java.util.stream.Collector;

@VertxGen
public interface MySQLConnection
extends SqlConnection {
    public static void connect(Vertx vertx, MySQLConnectOptions connectOptions, Handler<AsyncResult<MySQLConnection>> handler) {
        MySQLConnectionImpl.connect(vertx, connectOptions, handler);
    }

    public static void connect(Vertx vertx, String connectionUri, Handler<AsyncResult<MySQLConnection>> handler) {
        MySQLConnection.connect(vertx, MySQLConnectOptions.fromUri(connectionUri), handler);
    }

    public MySQLConnection prepare(String var1, Handler<AsyncResult<PreparedQuery>> var2);

    public MySQLConnection exceptionHandler(Handler<Throwable> var1);

    public MySQLConnection closeHandler(Handler<Void> var1);

    public MySQLConnection preparedQuery(String var1, Handler<AsyncResult<RowSet>> var2);

    @GenIgnore
    public <R> MySQLConnection preparedQuery(String var1, Collector<Row, ?, R> var2, Handler<AsyncResult<SqlResult<R>>> var3);

    public MySQLConnection query(String var1, Handler<AsyncResult<RowSet>> var2);

    @GenIgnore
    public <R> MySQLConnection query(String var1, Collector<Row, ?, R> var2, Handler<AsyncResult<SqlResult<R>>> var3);

    public MySQLConnection preparedQuery(String var1, Tuple var2, Handler<AsyncResult<RowSet>> var3);

    @GenIgnore
    public <R> MySQLConnection preparedQuery(String var1, Tuple var2, Collector<Row, ?, R> var3, Handler<AsyncResult<SqlResult<R>>> var4);

    @Fluent
    public MySQLConnection ping(Handler<AsyncResult<Void>> var1);

    @Fluent
    public MySQLConnection specifySchema(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public MySQLConnection getInternalStatistics(Handler<AsyncResult<String>> var1);

    @Fluent
    public MySQLConnection setOption(MySQLSetOption var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public MySQLConnection resetConnection(Handler<AsyncResult<Void>> var1);

    @Fluent
    public MySQLConnection debug(Handler<AsyncResult<Void>> var1);

    @Fluent
    public MySQLConnection changeUser(MySQLConnectOptions var1, Handler<AsyncResult<Void>> var2);
}

