/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.MySQLCollation;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.mysqlclient.impl.command.ChangeUserCommand;
import io.vertx.mysqlclient.impl.util.BufferUtils;
import io.vertx.mysqlclient.impl.util.Native41Authenticator;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;

class ChangeUserCommandCodec
extends CommandCodec<Void, ChangeUserCommand> {
    ChangeUserCommandCodec(ChangeUserCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendChangeUserCommand();
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength, int sequenceId) {
        short header = payload.getUnsignedByte(payload.readerIndex());
        switch (header) {
            case 254: {
                String pluginName = BufferUtils.readNullTerminatedString(payload, StandardCharsets.UTF_8);
                if (pluginName.equals("caching_sha2_password")) {
                    this.completionHandler.handle((Object)CommandResponse.failure((Throwable)new UnsupportedOperationException("unsupported authentication method: " + pluginName)));
                    return;
                }
                byte[] scramble = new byte[20];
                payload.readBytes(scramble);
                byte[] scrambledPassword = Native41Authenticator.encode(((ChangeUserCommand)this.cmd).password(), StandardCharsets.UTF_8, scramble);
                this.sendAuthSwitchResponse(scrambledPassword);
                break;
            }
            case 0: {
                this.completionHandler.handle((Object)CommandResponse.success(null));
                break;
            }
            case 255: {
                this.handleErrorPacketPayload(payload);
            }
        }
    }

    private void sendChangeUserCommand() {
        Map<String, String> clientConnectionAttributes;
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        packet.writeMediumLE(0);
        packet.writeByte(this.sequenceId);
        packet.writeByte(17);
        BufferUtils.writeNullTerminatedString(packet, ((ChangeUserCommand)this.cmd).username(), StandardCharsets.UTF_8);
        String password = ((ChangeUserCommand)this.cmd).password();
        if (password.isEmpty()) {
            packet.writeByte(0);
        } else {
            packet.writeByte(password.length());
            packet.writeCharSequence((CharSequence)password, StandardCharsets.UTF_8);
        }
        BufferUtils.writeNullTerminatedString(packet, ((ChangeUserCommand)this.cmd).database(), StandardCharsets.UTF_8);
        MySQLCollation collation = ((ChangeUserCommand)this.cmd).collation();
        int collationId = collation.collationId();
        this.encoder.charset = Charset.forName(collation.mappedJavaCharsetName());
        packet.writeShortLE(collationId);
        if ((this.encoder.clientCapabilitiesFlag & 0x80000) != 0) {
            BufferUtils.writeNullTerminatedString(packet, "mysql_native_password", StandardCharsets.UTF_8);
        }
        if ((clientConnectionAttributes = ((ChangeUserCommand)this.cmd).connectionAttributes()) != null && !clientConnectionAttributes.isEmpty()) {
            this.encoder.clientCapabilitiesFlag |= 0x100000;
            ByteBuf kv = this.encoder.chctx.alloc().ioBuffer();
            for (Map.Entry<String, String> attribute : clientConnectionAttributes.entrySet()) {
                if (attribute.getKey().equals("collation")) continue;
                BufferUtils.writeLengthEncodedString(kv, attribute.getKey(), StandardCharsets.UTF_8);
                BufferUtils.writeLengthEncodedString(kv, attribute.getValue(), StandardCharsets.UTF_8);
            }
            BufferUtils.writeLengthEncodedInteger(packet, kv.readableBytes());
            packet.writeBytes(kv);
        }
        int lenOfPayload = packet.writerIndex() - packetStartIdx - 4;
        packet.setMediumLE(packetStartIdx, lenOfPayload);
        this.sendPacket(packet, lenOfPayload);
    }

    private void sendAuthSwitchResponse(byte[] responseData) {
        int payloadLength = responseData.length;
        ByteBuf packet = this.allocateBuffer(payloadLength + 4);
        packet.writeMediumLE(payloadLength);
        packet.writeByte(this.sequenceId);
        packet.writeBytes(responseData);
        this.sendNonSplitPacket(packet);
    }
}

