/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.mysqlclient.impl.codec.CommandCodec;
import io.vertx.mysqlclient.impl.codec.MySQLEncoder;
import io.vertx.sqlclient.impl.command.CloseConnectionCommand;

class CloseConnectionCommandCodec
extends CommandCodec<Void, CloseConnectionCommand> {
    private static final int PAYLOAD_LENGTH = 1;

    CloseConnectionCommandCodec(CloseConnectionCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(MySQLEncoder encoder) {
        super.encode(encoder);
        this.sendQuitCommand();
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength, int sequenceId) {
    }

    private void sendQuitCommand() {
        ByteBuf packet = this.allocateBuffer(5);
        packet.writeMediumLE(1);
        packet.writeByte(this.sequenceId);
        packet.writeByte(1);
        this.sendNonSplitPacket(packet);
    }
}

